/*
 * @(#)ImageButton.java  (c) 1996 Jan Kautz
 */

package como.awt;

import como.util.*;
import java.awt.*;
import java.awt.image.*;

/**    
 * ImageButton is a button which uses images to represent
 * the states of the button - normal, pressed.
 * They don't have to be fully loaded! They will be loaded
 * asynchronously here!
 */

public class ImageClick extends Canvas {
    Image image;
    boolean focus = false;
    String text;
    Point pos = null;
    boolean editable;

	int RADIUS = 6;	

	int imagesizex = 400;
	int imagesizey = 200;

    /**
     */
    public ImageClick( Image i ) {
		image = i;
    }

	public void setPos(int x, int y) {
		setPos(new Point(x,y));
	}
    /**
     * Set the current state of the switch!
     * (If it is a button then do nothing!)
     * @param onoff indicating on or off
     */
    public void setPos( Point pos ) {
	    this.pos = pos;
	    repaint();
    }
    public void setEditable(boolean e) {
	editable = e;
    }
 
    /**
     * Get the current state of the switch! (if it's a button
     * you will get true if it's currently pressed).
     * @return if the switch is on then return true; else false.
     */
    public Point getPos() {
    	return pos;
    }
 
    /**
     * Move the focus to the next component
     * Does NOT work! (cause nextFocus() doesn't do what I wanted)
     */
    public boolean keyDown( Event evt, int key ) {
    	if( key == (int)'\t' || key == Event.DOWN || key == Event.RIGHT )
	{
	    nextFocus();	// let's move to the next focus
	    return true;
	}
    	return false;
    }

    
    /**
     * handle the MouseDownEvents.
     */
    public boolean handleEvent(Event evt) {
	// This will transform the coordinates of the event to the
	// pixel coordinates in the picture.

	evt.x = evt.x * image.getWidth(this) / size().width;
	evt.y = evt.y * image.getHeight(this) / size().height;

		if ((editable) && (evt.id == Event.MOUSE_DOWN)) {
			setPos(evt.x,evt.y);	
			evt.arg = getPos();
			evt.id = Event.ACTION_EVENT;
		}
	return false;
    }

    /**
     * Draws the picture on the screen (if parts are loaded,
     * then it draws those parts).
     * Overrides paint-Method. 
     */
    public void paint(Graphics graphics) {
	setImageSize();
    	if( image != null && 
	    (checkImage( image, size().width, size().height, this ) & (WIDTH|HEIGHT|ALLBITS)) != 0 ) {
	    // we know width and height of it -> draw it.
	    // or the image is complete -> draw it

	    graphics.drawImage(image, 0, 0, size().width,size().height, this);
	}
	else {
	    if( text != null )
	        graphics.drawString( text, 2, size().height/2 );
	}	
	if (pos != null) {
		graphics.setColor(Color.white);
		int x = pos.x * size().width / imagesizex;
		int y = pos.y * size().height / imagesizey;
		graphics.drawOval(x-RADIUS,y - RADIUS,RADIUS*2,RADIUS*2);	
	}
	}

	/* some lostFocus() Events don't come!
	// and the nextFocus does not work!
	if( focus == true ) {
	    do something
	}
	*/
    public boolean gotFocus( Event evt, Object what ) {
    	focus = true;
	// pass it back
    	return false;
    }

    public boolean lostFocus( Event evt, Object what ) {
    	focus = false;
	// pass it back
    	return false;
    }

    /**
     * Tell me all about the image ;-)
     * (inspired from Component.java)
     */
    public boolean imageUpdate(Image img, int flags,
                               int x, int y, int w, int h) {
        int rate = -1;

        if ((flags & (FRAMEBITS|ALLBITS)) != 0) {
            rate = 0;
        } else if ((flags & SOMEBITS) != 0) {
	    rate = 100;
        }
        if (rate >= 0) {
            repaint(rate, 0, 0, size().width, size().height);
        }
        return (flags & (ALLBITS|ABORT)) == 0;
    }
	public void setImageSize() {
		if (image != null) {
			int h = image.getHeight(this);
			int w = image.getWidth(this);
			if ((h>0)&&(w>0)) {
				imagesizex = w;
				imagesizey = h;
			}
		}
	}		
	public Dimension preferredSize() {
		setImageSize();
		Dimension d = new Dimension(imagesizex,imagesizey);
		return d;
	}
}

