package como.awt;

import java.awt.*;
import como.*;

public class ColorSelector extends Panel{

	Color currentcolor;
	Canvas colorsample;
	Scrollbar redSB,greenSB,blueSB;

	static final int LENGTH = 50;
	
	public Color getColor() {
		return currentcolor;
	}
	public void setColor(Color c) {
		currentcolor = c;
		colorsample.setBackground(currentcolor);
		colorsample.repaint();
	}
	
	public ColorSelector(Color c) {
		currentcolor = c;
		setLayout(new GridLayout(4,1));
		if (currentcolor  == null) currentcolor = Color.white;
		colorsample = new Canvas();
		colorsample.setBackground(currentcolor);
		add(colorsample);
		int max = 255;
		if (System.getProperty("os.name","").startsWith("Windows")) {
			// under Windows, the max that can be reached refers to the
			// value PLUS the page size. Since we want the value to be up to
			// 255, we have to add the page size
			max = max + LENGTH;
		}
		redSB = new Scrollbar(Scrollbar.HORIZONTAL,c.getRed(),LENGTH,0,255);
		redSB.setBackground(Color.red);
		greenSB = new Scrollbar(Scrollbar.HORIZONTAL,c.getGreen(),LENGTH,0,255);
		greenSB.setBackground(Color.green);
		blueSB = new Scrollbar(Scrollbar.HORIZONTAL,c.getBlue(),LENGTH,0,255);
		blueSB.setBackground(Color.blue);
		add(redSB);
		add(greenSB);
		add(blueSB);
	}
	public boolean handleEvent(Event evt) {
		if ((600 <= evt.id) && (evt.id <= 610))   {
			setColor(new Color(redSB.getValue(),greenSB.getValue(),blueSB.getValue()));
			evt.id = Event.ACTION_EVENT;
			evt.arg = currentcolor;
			evt.target = this;
			return false;
		}
		return false;
	}
}
	
