import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;

public class FMSettingsDialog extends JDialog {
  JFrame frame;
  FMClient client;
  JTextField serverHost;
  JTextField serverPort;
  FMSettings settings;

  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      String host;
      int port;


      try {
	port = Integer.parseInt(serverPort.getText());
	host = serverHost.getText();
	settings.setServerName(host);
	settings.setServerPort(port);
	settings.write("Config/jFM.settings");
      }
      catch(NumberFormatException e) {
	JOptionPane.showMessageDialog(frame, "Invalid port number");
	return;
      }
      catch(IOException e) {
	JOptionPane.showMessageDialog(frame, "Cannot save settings");
	FMSettingsDialog.this.setVisible(false);
	FMSettingsDialog.this.dispose();
      };

      JOptionPane.showMessageDialog(frame, "Settings saved");

      FMSettingsDialog.this.setVisible(false);
      FMSettingsDialog.this.dispose();
    };
  };

  class CancelButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMSettingsDialog.this.setVisible(false);
      FMSettingsDialog.this.dispose();
    };
  };

  public FMSettingsDialog(JFrame frame, FMSettings settings) {	
    super(frame, "Settings", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.settings = settings;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("Server host : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    serverHost = new JTextField(settings.getServerName(), 40);
    serverHost.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(serverHost, c);
    contentPane.add(serverHost);

    label = new JLabel("Server port : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    serverPort = new JTextField("" + settings.getServerPort(), 40);
    serverPort.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(serverPort, c);
    contentPane.add(serverPort);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("OK");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
    
    button = new JButton("Cancel");
    button.addActionListener(new CancelButtonListener());
    panel.add(button);
  };
};
