import java.io.*;
import java.net.*;
import java.util.*;

/**
 * <B>FMServer class</B>.<BR><BR>
 * Implements the server which waits for connections
 * and handles client requests
 */
public class FMServer extends Thread {
  static final int DEFAULT_PORT = 6699;
  
  ServerSocket mainSocket;
  Vector connectedUsers;
  FMUserDatabase userDatabase;

  /**
   * Public constructor.
   * Initializes the server on the DEFAULT port
   *
   * @exception java.io.IOException Unable to initialize the server
   */
  public FMServer(FMUserDatabase userDatabase) throws IOException {
    this(userDatabase, DEFAULT_PORT);
  };
  
  /**
   * Public constructor.
   * Initializes the server on a specified port
   *
   * @param port The port on which the server will listen for incoming connections
   * @exception java.io.IOException Unable to initialize the server
   */

  public FMServer(FMUserDatabase userDatabase, int port) throws IOException {
    mainSocket = new ServerSocket(port);
    connectedUsers = new Vector(50, 5);
    this.userDatabase = userDatabase;
  };
  
  /**
   * Add a user to the connected users list.
   *
   * @param user The user to be added
   */
  public void addUser(FMUser user) {
    FMUser currentUser;
    int i;
    
    for(i = 0; i < connectedUsers.size(); i++) {
      currentUser = (FMUser)connectedUsers.elementAt(i);
      if(user.getID() == currentUser.getID()) return;
    };
    
    connectedUsers.addElement(user);
  };
  
  /**
   * Remove a user from the connected user list.
   *
   * @param user The user to be removed
   */
  public void removeUser(FMUser user) {
    FMUser currentUser;
    int i;
    
    for(i = 0; i < connectedUsers.size(); i++) {
      currentUser = (FMUser)connectedUsers.elementAt(i);
      if(user.getID() == currentUser.getID()) {
	connectedUsers.removeElementAt(i);
	return;
      };
    };
  };
  
  /**
   * Return the connected users vector.
   *
   * @return The vector containing all the connected users
   */
  public Vector getUsers() {
    return connectedUsers;
  };
  
  /**
   * Main execution thread.
   * Waits for a connection and start a connection handler when
   * a new connection is established
   */
  public void run() {
    Socket connectionSocket;
    FMServerConnection connection;
    
    while(true) {
      try {
	connectionSocket = mainSocket.accept();
	connection = new FMServerConnection(this, userDatabase, connectionSocket);
	connection.start();
      }
      catch(IOException exception) {
	System.err.println("Unable to accept connection");
      };
    };
  };
};

