import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;

public class FMRegisterDialog extends JDialog {
  JFrame frame;
  JTextField nickNameField;
  JTextField realNameField;
  JPasswordField passwordField;
  JTextField eMailField;
  JTextArea infoArea;
  FMClient client;

  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMUser user;

      user = new FMUser();
      user.setNickName(nickNameField.getText());
      user.setRealName(realNameField.getText());
      user.setEMail(eMailField.getText());
      user.setPassword(passwordField.getText());
      user.setInfo(infoArea.getText());

      try {
	if(!client.register(user)) {
	  JOptionPane.showMessageDialog(frame, "Unable to register user");
	  return;
	};

	JOptionPane.showMessageDialog(frame, "User registered. ID : " + user.getID());
      }
      catch(IOException e) {
	JOptionPane.showMessageDialog(frame, "Error registering user");
	return;
      };
      
      FMRegisterDialog.this.setVisible(false);
      FMRegisterDialog.this.dispose();
      
    };
  };

  class CancelButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMRegisterDialog.this.setVisible(false);
      FMRegisterDialog.this.dispose();
    };
  };

  public FMRegisterDialog(JFrame frame, FMClient client) {	
    super(frame, "Register user", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.client = client;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("Nickname : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    nickNameField = new JTextField(40);
    nickNameField.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(nickNameField, c);
    contentPane.add(nickNameField);

    label = new JLabel("Real name : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    realNameField = new JTextField(40);
    realNameField.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(realNameField, c);
    contentPane.add(realNameField);

    label = new JLabel("Password : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    passwordField = new JPasswordField(40);
    passwordField.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(passwordField, c);
    contentPane.add(passwordField);

    label = new JLabel("E-Mail : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    eMailField = new JTextField(40);
    eMailField.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(eMailField, c);
    contentPane.add(eMailField);

    label = new JLabel("Info : ");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    infoArea = new JTextArea(10, 40);
    infoArea.setFont(new Font("fixed", Font.PLAIN, 14));
    scrollPane = new JScrollPane(infoArea);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Register");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
    
    button = new JButton("Cancel");
    button.addActionListener(new CancelButtonListener());
    panel.add(button);
  };
};
