import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class FMQueryDialog extends JDialog {
  JFrame frame;
  JComboBox queryType;
  JTextField queryData;
  JList queryList;
  DefaultListModel queryResults;
  FMMainWindow mainWindow;
  FMClient client;
  
  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMQueryDialog.this.setVisible(false);
      FMQueryDialog.this.dispose();
    };
  };
  
  class QueryButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      Vector matchings;
      Enumeration e;
      
      try {
	queryResults.removeAllElements();
	
	matchings = client.query(queryType.getSelectedIndex(), queryData.getText());
	e = matchings.elements();
	while(e.hasMoreElements()) {
	  FMUser user;
	  
	  user = (FMUser)e.nextElement();
	  queryResults.addElement(user);
	};
      }
      catch(IOException exception) {
	JOptionPane.showMessageDialog(frame, "Cannot submit query");
      };
    };
  };
  
  class AddButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMUser user;

      user = (FMUser)queryList.getSelectedValue();
      if(user != null) {
	mainWindow.addToUserList(user);
	queryResults.removeElement(user);
	
      };
    };
  };
	
  public FMQueryDialog(JFrame frame, FMMainWindow mainWindow, FMClient client) {	
    super(frame, "Add user by query", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;

    this.frame = frame;
    this.mainWindow = mainWindow;
    this.client = client;
    
    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("Query type :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);
    
    queryType = new JComboBox();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(queryType, c);
    queryType.addItem("By user ID");
    queryType.addItem("By nick name");
    queryType.addItem("By real name");
    queryType.addItem("By e-mail");
    contentPane.add(queryType);
    
    label = new JLabel("Query for :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);
    
    queryData = new JTextField(50);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(queryData, c);
    contentPane.add(queryData);
    
    button = new JButton("Query");
    button.addActionListener(new QueryButtonListener());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(button, c);
    contentPane.add(button);
    
    label = new JLabel("Query results :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);
    
    queryResults = new DefaultListModel();
    queryList = new JList(queryResults);
    scrollPane = new JScrollPane(queryList);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);
    
    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Add");
    button.addActionListener(new AddButtonListener());
    panel.add(button);
    
    button = new JButton("OK");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
  };
};




