import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class FMOffLineMessageDialog extends JDialog {
  JFrame frame;
  FMClient client;
  JTextField titleField;
  JTextArea messageArea;
  FMUser toUser;

  class CancelButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMOffLineMessageDialog.this.setVisible(false);
      FMOffLineMessageDialog.this.dispose();
    };
  };

  class SendButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      try {
	if(!client.sendOffLineMessage(toUser, titleField.getText(), messageArea.getText())) {
	  JOptionPane.showMessageDialog(frame, "Unable to send message");
	}
	else JOptionPane.showMessageDialog(frame, "Message sent");
	
	FMOffLineMessageDialog.this.setVisible(false);
	FMOffLineMessageDialog.this.dispose(); 
      }
      catch(IOException e) {
	JOptionPane.showMessageDialog(frame, "Unable to send message");
      };
    };
  };
  
  public FMOffLineMessageDialog(JFrame frame, FMClient client, FMUser toUser) {	
    super(frame, "New off-line message", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.frame = frame;
    this.client = client;
    this.toUser = toUser;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;

    label = new JLabel("To : " + toUser);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);
    
    label = new JLabel("Title :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    titleField = new JTextField(40);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(titleField, c);
    contentPane.add(titleField);

    label = new JLabel("Message :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    messageArea = new JTextArea(5, 40);
    messageArea.setFont(new Font("fixed", Font.PLAIN, 14));
    scrollPane = new JScrollPane(messageArea);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Send");
    button.addActionListener(new SendButtonListener());
    panel.add(button);
    
    button = new JButton("Cancel");
    button.addActionListener(new CancelButtonListener());
    panel.add(button);
  };
};
