import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;

public class FMMessageViewDialog extends JDialog {
  JFrame frame;

  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMMessageViewDialog.this.setVisible(false);
      FMMessageViewDialog.this.dispose();
    };
  };

  public FMMessageViewDialog(JFrame frame, FMOffLineMessage message) {	
    super(frame, "View message", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.frame = frame;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("From : " + message.getFrom());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("To : " + message.getTo());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("Title : " + message.getTitle());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("Text : ");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    textArea = new JTextArea(5, 40);
    textArea.setFont(new Font("fixed", Font.PLAIN, 14));
    textArea.setText(message.getMessage());
    scrollPane = new JScrollPane(textArea);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("OK");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
  };
};
