import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class FMInfoDialog extends JDialog {
  JFrame frame;
  FMUser user;
  
  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMInfoDialog.this.setVisible(false);
      FMInfoDialog.this.dispose();
    };
  };
  
  public FMInfoDialog(JFrame frame, FMUser user) {	
    super(frame, "User info", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;

    this.frame = frame;
    this.user = user;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("User ID :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("" + user.getID());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("Nickname :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel(user.getNickName());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("Real name :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("" + user.getRealName());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("E-Mail :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("" + user.getEMail());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("Info :");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    label = new JLabel("" + user.getInfo());
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    if(user.getHostName() != null) {
      label = new JLabel("Connected from :");
      c.gridwidth = GridBagConstraints.RELATIVE;
      gridBag.setConstraints(label, c);
      contentPane.add(label);
      
      label = new JLabel("" + user.getHostName());
      c.gridwidth = GridBagConstraints.REMAINDER;
      gridBag.setConstraints(label, c);
      contentPane.add(label);
    };
    
    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("OK");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
  };
};




