import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

class FMGetFileConnection extends Thread {
  FMGetFileDialog getFileDialog;
  Socket socket;
  FileOutputStream fos;
  DataInputStream is;
  DataOutputStream os;

  public FMGetFileConnection(FMGetFileDialog getFileDialog, Socket socket, String fileName) throws IOException {
    this.getFileDialog = getFileDialog;
    this.socket = socket;

    fos = new FileOutputStream(fileName);
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(fos);
  };

  public void close() {
    try {
      socket.close();
      os.close();
    }
    catch(IOException e) {
    };
    stop();
  };

  public void run() {
    byte[] buffer;
    int bytesRead = 0;
    int bytesWritten;
    byte b;

    buffer = new byte[2048];
    bytesWritten = 0;
    while(true) {
      try {
	bytesRead = is.read(buffer);
	
	if(bytesRead == -1) {
	  getFileDialog.button.setText("OK");
	  break;
	};
	
	os.write(buffer, 0, bytesRead);
	bytesWritten += bytesRead;
	
	getFileDialog.info.setText("Received : " + bytesWritten);
      }
      catch(IOException e) {
	getFileDialog.button.setText("OK");
	break;
      };
    };
  };
};	
	
public class FMGetFileDialog extends JDialog {
  JFrame frame;
  FMUser user;
  JLabel info;
  FMGetFileConnection getFileConnection;
  JButton button;
  
  class AbortButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      getFileConnection.close();
      FMGetFileDialog.this.setVisible(false);
      FMGetFileDialog.this.dispose();
    };
  };

  public void start() {
    getFileConnection.start();
  };

  public FMGetFileDialog(JFrame frame, FMUser user, Socket socket, String fileName) throws IOException {	
    super(frame, "Getting file " + fileName + " from  : " + user.getNickName() + " [" + user.getRealName() + "]", false);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.frame = frame;
    this.user = user;

    getFileConnection = new FMGetFileConnection(this, socket, fileName);

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    info = new JLabel("Local :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(info, c);
    contentPane.add(info);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Abort");
    button.addActionListener(new AbortButtonListener());
    panel.add(button);

    //getFileConnection.start();
  };
};
