import javax.swing.*;
import javax.swing.border.*;
import javax.swing.ImageIcon;
import java.awt.*;
import java.awt.event.*;

/** Fenetre qui sert a afficher des messages d'erreurs */

public class JErreur extends JDialog implements ActionListener {
    private JFrame parent;
    
    public JErreur(JFrame parent, String erreur) {
	super(parent, true);
	this.parent = parent;
	
	setTitle("jCD - Erreur");
	
	JPanel jp = new JPanel();
	jp.setBorder(new EmptyBorder(8, 8, 8, 8));
	jp.setLayout(new GridLayout (0,1));
	JLabel jl;
	
	jl = new JLabel("Erreur : ", new ImageIcon("images/caution.gif"), 0);
	jp.add(jl);
	jl = new JLabel(erreur);
	jp.add(jl);

	JPanel panelBouton = new JPanel();
	JButton bouton = new JButton(" OK ");
	bouton.setFont(new Font("Dialog", Font.BOLD, 12));
	bouton.addActionListener(this);
	bouton.setActionCommand("ok");
	panelBouton.add(bouton);
	
	jp.add(panelBouton);
	
	getContentPane().add(jp);

	pack();
	setResizable(false);
	
	FermeurDeFenetre fermeurFenetre = new FermeurDeFenetre();
	addWindowListener(fermeurFenetre);
    }
    
    public void setVisible(boolean b) {
	if(b) {
	    Rectangle bounds = getParent().getBounds();
	    Rectangle abounds = getBounds();
	    
	    setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
			bounds.y + (bounds.height - abounds.height)/2);
	}
	super.setVisible(b);
    }
    
    public void actionPerformed(ActionEvent e) {
	String command = e.getActionCommand();
	
	if (command.equals("ok")) {
	    setVisible(false);
	}
    }
    
    /** 
     * Une classe interne pour gerer la fermeture de la fenetre
     */
    class FermeurDeFenetre extends WindowAdapter {
	public void windowClosing(WindowEvent event){
	    dispose();
	}
    }
}
    

