import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.*;
import java.io.*;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JMenuBar.*;
import javax.swing.ImageIcon;
import javax.swing.JProgressBar;
import javax.swing.tree.*;
import java.util.HashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.lang.Runtime;

/** Fenetre principale de l'application. */
public class jCD extends JFrame implements ActionListener {
  /** Contient l'arbre en cours de consultation */
  private JScrollPane treePane;
  /** Fenetre d'information */
  private JAPropos aPropos;
  /** Pour afficher l'arborescence du CD en cours de consultation */
  private static JTree jBD;
  /** Pour stocker l'arborescence du CD en cours de consultation */
  public static MakeTree bd;
  /** Fenetre d'information sur le CD en cours de consultation */
  private static JCoteDroit panelDroit;
  /** Lors du rajout d'un CD dans la base de donnees, demande un nom*/
  private JDemandeNom demandeNom;
  /** Fenetre d'aide, succinte */
  public static JAide frameAide;
  /** Fenetre d'erreur, generique */
  private JErreur erreur;
  /** La base de donnee contenant toutes les references de CD */
  public static HashMap baseDonnee = new HashMap();
  /** Chemin d'acces au CD-ROM */
  public static File pathCD = null;
  /** Chemin d'acces a un viewer de Ps */
  private static String pathPsViewer = "gv";
  /** Commande d'impression */
  private static String pathPrinter = "lpr";
  /** Booleen qui contient vraie si la base de donnee a ete sauvegardee depuis sa derniere modification */
  private static boolean saveBD = true;
  /** JComBox contenant les differents CDs de la base de donnees */
  public static JBase JCombo;
  /** Variable globale annoncant le resultat de la recherche en cours */
  public static ArrayList cheminVolume;
  public static JResultat resultat;
  /** Bouton qui permet de changer la disponibilite du CD*/
  public static JCheckBox bouton01;
    
  public jCD() {
    // Titre de la fenetre
    super("jCD");


    // Pour le "Look'n Feel". Celui de Java est bien
    try {
      UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
      // Pour le L&F du systeme : 
      // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    } catch (Exception exc) {
      System.err.println("Erreur de chargement de Look'n Feel : " + exc);
    }


    // Taille initiale de la Frame
    setSize(600, 600);

    // Ecouteur de WindowEvent
    FermeurDeFenetre fermeurFenetre = new FermeurDeFenetre();
    addWindowListener(fermeurFenetre);

    // Barre des menus
    JMenuBar menuBar = creeMenu();

    // Barre des icones
    JPanel toolBar = creeJToolBarPanel();
    getContentPane().add(toolBar, BorderLayout.NORTH);


    // Pour les informations sur la base de donnees consultee
    panelDroit = new JCoteDroit();
    getContentPane().add(panelDroit, BorderLayout.EAST);

    // Combo Box
    JCombo = new JBase();
    getContentPane().add(JCombo, BorderLayout.SOUTH);
    
    // On ajoute l'arbre
    treePane = new JScrollPane(jBD);
    getContentPane().add(treePane);
    
    // On remplit la combo box
    
    Collection elements = baseDonnee.values();
    Iterator it = elements.iterator();
    MakeTree tmp = null;
    String s;
    
    for ( ; it.hasNext() ; ) {
      tmp = (MakeTree)it.next();
      s = tmp.getNomVolume()+" - "+tmp.getProprietaire();
      JCombo.ajouteCDCombo(s);
    }

    // Fenetre d'infos sur le programme et les auteurs...
    aPropos = new JAPropos(this);
    
    // Fenetre d'infos sur les CD rajoutes
    demandeNom = new JDemandeNom(this);

    // Fenetre d'aide
    frameAide = new JAide();

    setVisible(true);


  }
  
  /*
   * Traitement des actions
   */
  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    
    if (command.equals("actualiser"))
      actualiser();
    else if (command.equals("ajouterCD")) 
      ajouterCD();
    else if (command.equals("enleverCD"))
      enleverCD();
    else if (command.equals("serialisation")){
      serialise(baseDonnee,"baseDonnee.jcd");
      saveBD = true;  
    }
    else if (command.equals("rechercheCD"))
      rechercheCD();
    else if (command.equals("rechercheBD"))
      rechercheBD();
    else if (command.equals("imprimer"))
      imprimer();
    else if (command.equals("apercu"))
      apercu();
    else if (command.equals("changePsViewer"))
      changePsViewer();
    else if (command.equals("changePath"))
      changePath();
    else if (command.equals("changePrint"))
      changePrint();
    else if (command.equals("apropos"))
      aPropos.setVisible(true);
    else if (command.equals("chgDispo"))
      chgDispo();
    else if (command.equals("aide")) 
      aide();        
    else if (command.equals("quitter"))
      quitter();
  }
		
    /** Construit et renvoie la barre de menus */
    public JMenuBar creeMenu() {
	JMenuBar jmb = new JMenuBar();
	JMenuItem item, tempMenu;		
	
	// Menu Fichier
	JMenu fichier = new JMenu("Fichier");
	fichier.setMnemonic('F');

	fichier.add(item = new JMenuItem("Actualiser"));
	item.setMnemonic('A');
	item.addActionListener(this);
	item.setActionCommand("actualiser");
	
	fichier.add(tempMenu = new JMenu("Recherche"));
	tempMenu.setMnemonic('R');
	
	tempMenu.add(item = new JMenuItem("Sur le CD"));	
	item.setMnemonic('C');
	item.addActionListener(this);
	item.setActionCommand("rechercheCD");
	
	tempMenu.add(item = new JMenuItem("Dans la base de donnee"));
	item.setMnemonic('B');
	item.addActionListener(this);
	item.setActionCommand("rechercheBD");
	
 	fichier.add(item = new JMenuItem("Apercu avant impression"));
	item.setMnemonic('A');
	item.addActionListener(this);
	item.setActionCommand("apercu");

	fichier.add(item = new JMenuItem("Imprimer"));
	item.setMnemonic('I');
	item.addActionListener(this);
	item.setActionCommand("imprimer");
	
	fichier.add(new JSeparator());
	fichier.add(item = new JMenuItem("Quitter"));
	item.setMnemonic('Q');
	item.addActionListener(this);
	item.setActionCommand("quitter");
	
	jmb.add(fichier);
	
	// Menu Base de Donnees
	JMenu bd = new JMenu("Base de donne");
	bd.setMnemonic('B');

	bd.add(item = new JMenuItem("Ajouter le CD"));
	bd.setMnemonic('A');
	item.addActionListener(this);
	item.setActionCommand("ajouterCD");

	bd.add(item = new JMenuItem("Enlever le CD"));
	bd.setMnemonic('E');
	item.addActionListener(this);
	item.setActionCommand("enleverCD");

	bd.add(new JSeparator());
	
	bd.add(item = new JMenuItem("Sauvegarde"));
	item.addActionListener(this);
	item.setActionCommand("serialisation");

	jmb.add(bd);

	// Menu Divers
	JMenu divers = new JMenu("Options");
	divers.setMnemonic('O');
	divers.add(item = new JMenuItem("Changer de PostScript viewer"));
	item.addActionListener(this);
	item.setActionCommand("changePsViewer");

	divers.add(new JSeparator());
	
	divers.add(item = new JMenuItem("Changer de commande d'impression"));
	item.addActionListener(this);
	item.setActionCommand("changePrint");

	divers.add(new JSeparator());
	
	divers.add(item = new JMenuItem("Changer le path"));
	item.addActionListener(this);
	item.setActionCommand("changePath");
	
	jmb.add(divers);
	
	// Menu Aide
	JMenu aide = new JMenu("Aide");
	aide.setMnemonic('A');
	aide.add(item = new JMenuItem("Aide"));
	item.addActionListener(this);
	item.setActionCommand("aide");

	aide.add(new JSeparator());
	
	aide.add(item = new JMenuItem("A Propos"));
	item.addActionListener(this);
	item.setActionCommand("apropos");

	// setHelpMenu(aide);
	// Tant pis : "This method is not yet implemented.", d'apres
	// la doc. Merci Sun...

	jmb.add(Box.createHorizontalGlue());
	jmb.add(aide);
	
	setJMenuBar(jmb);
	
	return jmb;
    }
		    
    /** Construit et renvoie la barre d'outils */
    public JPanel creeJToolBarPanel() {
	JPanel jp = new JPanel();
	JButton bouton;
	// Pour un placement des icones horizontalement 
	jp.setLayout(new BoxLayout(jp, BoxLayout.X_AXIS));
	
	JToolBar jtb = new JToolBar();

	jtb.add(bouton = new JButton(new ImageIcon("images/cameraflash.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("actualiser");
	bouton.setToolTipText("Actualiser");
	jtb.addSeparator(new Dimension(14,14));
	
	jtb.add(bouton = new JButton(new ImageIcon("images/datastore.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("ajouterCD");
	bouton.setToolTipText("Ajouter le CD a la base de donnee");
	jtb.addSeparator(new Dimension(3,14));

	jtb.add(bouton = new JButton(new ImageIcon("images/dataextract.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("enleverCD");
	bouton.setToolTipText("Enlever le CD de la base de donnee");
	jtb.addSeparator(new Dimension(14,14));
	
	jtb.add(bouton = new JButton(new ImageIcon("images/save.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("serialisation");
	bouton.setToolTipText("Sauvegarde de la base de donnee");
	jtb.addSeparator(new Dimension(14,14));

	jtb.add(bouton = new JButton(new ImageIcon("images/binocular.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("rechercheCD");
	bouton.setToolTipText("Rechercher sur le CD");
	jtb.addSeparator(new Dimension(3,14));

	jtb.add(bouton = new JButton(new ImageIcon("images/documentmag.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("rechercheBD");
	bouton.setToolTipText("Rechercher dans la base de donnee");
	jtb.addSeparator(new Dimension(14,14));
        
	jtb.add(bouton = new JButton(new ImageIcon("images/print.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("imprimer");
	bouton.setToolTipText("Imprimer");
	jtb.addSeparator(new Dimension(14,14));

	jtb.add(bouton = new JButton(new ImageIcon("images/inform.gif")));
	bouton.addActionListener(this);
	bouton.setActionCommand("apropos");
	bouton.setToolTipText("A propos...");
	jtb.addSeparator(new Dimension(80,14));
	
	bouton01 = new JCheckBox(new ImageIcon("images/circle_0.gif"));
	bouton01.setSelectedIcon(new ImageIcon("images/circle_1.gif"));
        bouton01.doClick();
	bouton01.setBorder(new LineBorder(Color.black, 3));   
	jtb.add(bouton01);
	bouton01.addActionListener(this);
	bouton01.setActionCommand("chgDispo");
	bouton01.setToolTipText("Changer la disponiblite du CD");
	jtb.addSeparator(new Dimension(14,14));
	// Pour empecher le deplacement de la barre d'outils
	//jtb.setFloatable(false);
	
	jp.add(jtb);
	return jp;
    }
    
    
    
    /*
     * On surchage la methode setVisible pour pouvoir positionner la
     * fenetre au centre de l'ecran (cf M.B. TP#4)
     */
    public void setVisible(boolean b ){
	if(b) {
	    // Fenetre centree au milieu de l'ecran
	    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	    int largeurEcran = screenSize.width;
	    int hauteurEcran = screenSize.height;
	    
	    int largeurFrame = getSize().width;
	    int hauteurFrame = getSize().height;
	    int posX = (largeurEcran  -largeurFrame)/2;
	    int posY = (hauteurEcran - hauteurFrame)/2;
	    
	    setLocation(posX, posY);
	}
	super.setVisible(b);
    }
    
    
    /** 
     * Une classe interne pour gerer la fermeture de la fenetre
     */
  class FermeurDeFenetre extends WindowAdapter {
    public void windowClosing(WindowEvent event){
      if (saveBD) {
	JOptionPane.showMessageDialog(null, "Merci d'avoir utilise jCD !", "quit", JOptionPane.PLAIN_MESSAGE);
      }
      else {
	if (JOptionPane.showConfirmDialog(null,"Sauvegarder la base de donnee avant de quitter ?","quit",JOptionPane.YES_NO_OPTION ,JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
	  jCD.serialise((Object)baseDonnee,"baseDonnee.jcd");
	}
      }
      System.exit(0);
    }
  }
  
  
  /** Affiche l'arborescence du CD en cours de lecture */
  public static void actualiser() {
    bd = new MakeTree(pathCD);
    JCombo.jcb.setSelectedItem("CD-ROM courant");
    chargerCD();  
  }
        
  /** Recuperer l'arborescence d'un CD classe dans la base de donnee */
  public static void chargerCD() {
    jBD.setModel(new DefaultTreeModel(bd.getTree()));
    if (bd.getDispo() && (!bouton01.isSelected()))
      bouton01.doClick();
    else if (!bd.getDispo() && bouton01.isSelected())
      bouton01.doClick();
    if (bd.typeCD().equals("CD-Audio")) {
      jBD.setEditable(true); // on peut editer les pistes d'un cd audio !
    }
    panelDroit.actualise(bd.typeCD(), bd.getTaille(), bd.getNbFichiers(), bd.getDispo());  
  }
  
  
  /** Ajoute un emplacement a la Base de donnee */
  public void ajouterCD() {
    if (baseDonnee.containsValue(bd)) // ca marche pas comme je voudrais...
      JOptionPane.showMessageDialog(null, "Le CD est deja enregistre dans la base de donnee !!", "erreur", JOptionPane.ERROR_MESSAGE);
    else {
      demandeNom.setVisible(true);
      bd.setNomVolume(demandeNom.getNom());
      bd.setProprietaire(demandeNom.getProp());
      String key = bd.getNomVolume()+" - "+bd.getProprietaire();
      while (baseDonnee.containsKey(key)) {
	JOptionPane.showMessageDialog(null, "alert", "alert", JOptionPane.ERROR_MESSAGE);
	demandeNom.setVisible(true);
	bd.setNomVolume(demandeNom.getNom());
	bd.setProprietaire(demandeNom.getProp());
	key = bd.getNomVolume()+" - "+bd.getProprietaire();
	}
      baseDonnee.put(key,bd);
      // Et on rajoute le nom dans la Combo Box
      JCombo.ajouteCDCombo(key); 
      // Enfin on indique que la base de donnee a ete modifiee depuis la derniere sauvegarde
      saveBD = false;
    }
  }

  /** Enlever le CD dont l'arborescence est affichee de la Base de donnee */
  // on ne peut pas enlever le CD-ROM courant car il n'a pas d'entree dans la hashmap
  public void enleverCD(){
    if (((String)JCombo.jcb.getSelectedItem()).equals("CD-ROM courant")){
      JOptionPane.showMessageDialog(null, "Le cd courant n'est pas dans la base de donnee !", "erreur", JOptionPane.ERROR_MESSAGE);
	}
    else {
      if (JOptionPane.showConfirmDialog(null,"Etes vous sur de vouloir retirer ce CD de la base de donnee ?","remove CD",JOptionPane.YES_NO_OPTION ,JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
	String key = bd.getNomVolume()+" - "+bd.getProprietaire();
	baseDonnee.remove(key);
	JCombo.jcb.removeItem(key);
      }
    }
  }
  
  public void apercu() {
    GenerePS impression;
    impression = new GenerePS("jaquette.ps", bd);
    impression.ecrisPS();
    try {
      Runtime.getRuntime().exec(new String(pathPsViewer + " jaquette.ps"));
    } catch (Exception e) {
      JOptionPane.showMessageDialog(null, "Impossible d'ouvrir votre viewer PostScript!", "no PS viewer", JOptionPane.ERROR_MESSAGE);
    }
  }
  
  public void imprimer() {
    try {
      Runtime.getRuntime().exec(new String(pathPrinter + " jaquette.ps"));
    } catch (Exception e) {
      JOptionPane.showMessageDialog(null, "Impression impossible !", "print error", JOptionPane.ERROR_MESSAGE);
    }
  }

  /** Si l'on veut changer de lecteur CD-ROM */  
  public void changePath(){
    String path;
    boolean cancel = false;
    path = JOptionPane.showInputDialog(null,"Veuillez entrez le chemin d'acces a votre CD-ROM","Changement du path",JOptionPane.INFORMATION_MESSAGE);
    if (path == null) path="";
    pathCD = new File(path);
    while (!pathCD.isDirectory()) {
	path = JOptionPane.showInputDialog("Chemin non valide. Ressayez");
	if (path == null) {
	  cancel = true;
	  break;
	}
	pathCD = new File(path);
      }
    if (!cancel) {
      //On serialise le nouveau chemin a la place de l'ancien
      try {
	FileOutputStream fo = new FileOutputStream("pathCD.jcd");
	ObjectOutputStream so = new ObjectOutputStream(fo);
	so.writeObject(pathCD);
	so.flush();
	so.close();
      } catch (Exception e3) {
	e3.printStackTrace();
	System.exit(1);
      }
      actualiser();
    }
  }
  
  /** Deserialise la base de donnee a partir du fichier baseDonnee.jcd s'il existe */
  public static void deserialisation(){
    try {
      FileInputStream fi = new FileInputStream("baseDonnee.jcd");
      ObjectInputStream si = new ObjectInputStream(fi);  
      baseDonnee = (HashMap)si.readObject();
      si.close();
    } catch (Exception e) {
      JOptionPane.showMessageDialog(null, "Aucune basse de donnee n'a ete trouvee.", "jCD - Chargement", JOptionPane.INFORMATION_MESSAGE);
    }
  }
  
  public void rechercheCD(){
    String nomFichier;
    nomFichier = JOptionPane.showInputDialog(null,"Entrez le nom du fichier  chercher","Recherche",JOptionPane.INFORMATION_MESSAGE);
    cheminVolume = new ArrayList();
    String tmp;
    if (nomFichier != null) {
      if (bd.getNomVolume() == null) { //on cherche dans le CD Courant
	tmp = "CD-ROM courant";
      }
      else { // on cherche dans un CD de la base de donnee
	tmp = bd.getNomVolume()+" - "+bd.getProprietaire();
      }
      rechercheCD2(bd.getTree(),nomFichier,"/"+bd.getName(),tmp);
      if (!cheminVolume.isEmpty()) {//on a trouve quelquechose
	resultat = new JResultat(cheminVolume);
	resultat.show();
      }
      else
	JOptionPane.showMessageDialog(null, "La recherche n'a pas abouti", "Search failed", JOptionPane.PLAIN_MESSAGE);
    }
  }
  
  public void rechercheCD2(DefaultMutableTreeNode arbre,String nf,String pathCourant,String nomCdCourant){
    int compteFils = 0;
    int nbFils = arbre.getChildCount();
    if (arbre.getUserObject().equals(nf)) {
      cheminVolume.add(new CheminVolume(nomCdCourant,pathCourant));
    }
    while (compteFils < nbFils) {
      DefaultMutableTreeNode next = (DefaultMutableTreeNode)arbre.getChildAt(compteFils++);
      rechercheCD2(next,nf,pathCourant+"/"+next.getUserObject(),nomCdCourant);
    }
  }
  
  void rechercheBD(){
    String nomFichier;
    cheminVolume = new ArrayList();
    nomFichier = JOptionPane.showInputDialog(null,"Entrez le nom du fichier  chercher","Recherche",JOptionPane.INFORMATION_MESSAGE);
    if (nomFichier != null) {
      Collection elements = baseDonnee.values();
      Iterator it = elements.iterator();
      MakeTree tmp = null;
      String s;
      for ( ; it.hasNext() ; ) {
	tmp = (MakeTree)it.next();
	rechercheCD2(tmp.getTree(),nomFichier, "/" + tmp.getName(), tmp.getNomVolume()+ " - " + tmp.getProprietaire());
      }
      if (!cheminVolume.isEmpty()) {//on a trouve quelquechose
	resultat = new JResultat(cheminVolume);
	resultat.show();
      }
      else
	JOptionPane.showMessageDialog(null, "La recherche n'a pas abouti", "Search failed", JOptionPane.PLAIN_MESSAGE);
    }
  }

  /** Choix d'un viewer de PostScript */
  public void changePsViewer() {
    pathPsViewer = JOptionPane.showInputDialog(null,"Indiquez le nom de votre viewer de PostScript","Ps viewer",JOptionPane.INFORMATION_MESSAGE);
    //On serialise le nouveau chemin a la place de l'ancien
    serialise(pathPsViewer,"pathPsViewer.jcd");
  }
  
  /** Choix de la commande d'impression */
  public void changePrint() {
    pathPsViewer = JOptionPane.showInputDialog(null,"Indiquez le nom de votre viewer de PostScript","Print commande",JOptionPane.INFORMATION_MESSAGE);
    //On serialise le nouveau chemin a la place de l'ancien
    serialise(pathPsViewer,"pathPrintCommande.jcd");
  }
  
  /** Gestion de la disponiblite du CD */
  public void chgDispo() {
    if (bd.getDispo())
      bd.setDispo(false);
    else
      bd.setDispo(true);
    panelDroit.actualise(bd.typeCD(), bd.getTaille(), bd.getNbFichiers(), bd.getDispo());
  } 
  
  

  /** Quitte le programme */
  public void quitter(){
    boolean quit = false;
    if (saveBD) {
      if (JOptionPane.showConfirmDialog(null,"Quitter jCD ?","quit",JOptionPane.OK_CANCEL_OPTION ,JOptionPane.QUESTION_MESSAGE) == JOptionPane.OK_OPTION)
	quit = true;
    }
    else {
      int i = JOptionPane.showConfirmDialog(null,"Sauvegarder la base de donnee avant de quitter ?","quit",JOptionPane.YES_NO_CANCEL_OPTION ,JOptionPane.QUESTION_MESSAGE);
      if (i == JOptionPane.YES_OPTION) {
	serialise((Object)baseDonnee,"baseDonnee.jcd");
	quit = true;
      }
      else {
	if (i == JOptionPane.NO_OPTION) {
	  quit = true;
	}
      }
    }
    if (quit) {
      dispose();
      System.exit(0);
    }
  }

  public void aide() {
    frameAide.show();
  }

  





  public static void serialise(Object obj,String path){
    try {
	FileOutputStream fo = new FileOutputStream(path);
	ObjectOutputStream so = new ObjectOutputStream(fo);
	so.writeObject(obj);
	so.flush();
	so.close();
      } catch (Exception e3) {
	e3.printStackTrace();
	System.exit(1);
      }
  }

  public static void main(String args[]) {
    // On cherche dans le fichier de sauvegarde "pathCD.jcd" le path du CD-ROM. 
    // Si cette sauvegarde n'existe pas, on demande a l'utilisateur d'entrer un chemin.
    String path;
    try {
      FileInputStream fi = new FileInputStream("pathCD.jcd");
      ObjectInputStream si = new ObjectInputStream(fi);  
      pathCD = (File)si.readObject();
      si.close();
    } catch (Exception e) { // Si cette sauvegarde n'existe pas, on demande a l'utilisateur d'entrer un chemin.
      path = JOptionPane.showInputDialog(null,"Veuillez entrez le chemin d'acces a votre CD-ROM","Premiere utilisation de jCD !",JOptionPane.INFORMATION_MESSAGE);
      if (path == null) path="";
      pathCD = new File(path);
      while (!pathCD.isDirectory()) {
	path = JOptionPane.showInputDialog("Chemin non valide. Ressayez");
	if (path == null) path="";
	pathCD = new File(path);
      }
      serialise(pathCD,"pathCD.jcd");
    }
    
    try { //on recupere le viewer de PostScript
      FileInputStream fi = new FileInputStream("pathPsViewer.jcd");
      ObjectInputStream si = new ObjectInputStream(fi);  
      pathPsViewer = (String)si.readObject();
      si.close();
    } catch (Exception e2) { // pas grave
    }
    try { // on recupere la commande d'impression
      FileInputStream fi = new FileInputStream("pathPrinter.jcd");
      ObjectInputStream si = new ObjectInputStream(fi);  
      pathPrinter = (String)si.readObject();
      si.close();
    } catch (Exception e2) { // tant pis
    }
    
    bd = new MakeTree(pathCD);
    jBD = new JTree(bd.getTree());
    // jBD.setEditable(true); Si on veut rendre l'arbre editable....
    // C'est parti !
    deserialisation();

    new jCD();
  }
}
    


