import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.ImageIcon;
import javax.swing.border.*;

public class JDemandeNom extends JDialog implements ActionListener {
  private JFrame parent;
  private JTextField jtfNom, jtfProp;
  
  public JDemandeNom(JFrame parent) {
    super(parent, true);
    this.parent = parent;
    JPanel jp, panelBouton, panelNom, panelProp;
    JLabel jl1, jl2;
    JButton jb;
    
    jp = new JPanel(new GridLayout(0, 1));
    jp.setBorder(new EmptyBorder(8, 8, 8, 8));
    jp.setLayout(new BoxLayout(jp, BoxLayout.Y_AXIS));
    setSize(275, 150);
    setTitle("jCD - Nouvelle Entree");
    
    jl1 = new JLabel("Nom du volume", new ImageIcon("images/cd.gif"), 0);
    panelNom = new JPanel();
    jtfNom = new JTextField("nouvelle entree", 20);
    jtfNom.addActionListener(this);
    panelNom.add(jtfNom);
    
    jl2 = new JLabel("Proprietaire", new ImageIcon("images/user.gif"), 0);
    panelProp = new JPanel();
    jtfProp = new JTextField("Tartanpion", 20);
    jtfProp.addActionListener(this);
    panelProp.add(jtfProp);
    
    jb = new JButton(" OK ");
    panelBouton = new JPanel();
    jb.setFont(new Font("Dialog", Font.BOLD, 12));
    jb.addActionListener(this);
    jb.setActionCommand("ok");
    panelBouton.add(jb);
    
    jp.add(jl1);
    jp.add(panelNom);
    jp.add(jl2);    
    jp.add(panelProp);
    jp.add(panelBouton);
    
    getContentPane().add(jp);
    pack();
    setResizable(false);
    
    FermeurDeFenetre fermeurFenetre = new FermeurDeFenetre();
    addWindowListener(fermeurFenetre);
  }
  
  public void setVisible(boolean b) {
    if(b) {
      Rectangle bounds = getParent().getBounds();
      Rectangle abounds = getBounds();
      
      setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
                  bounds.y + (bounds.height - abounds.height)/2);
    }
    super.setVisible(b);
  }
  
  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    
    if (command.equals("ok")) {
      setVisible(false);
    }
  }
  
  /** Methode appele par jCD apres que l'utilisateur est presse 
   *  la touche OK de cette fenetre */
  public String getNom() {
    String temp = new String(jtfNom.getText());
    jtfNom.setText("nouvelle entree");
    if (temp.length() > 30)
      return temp.substring(0, 30);
    else
      return temp;
  }
  
  /** Comme la precedente, mais renvoie le Proprietaire */
  public String getProp() {
    String temp = new String(jtfProp.getText());
    jtfProp.setText("Tartanpion");
    if (temp.length() > 30)
      return temp.substring(0, 30);
    else
      return temp;
      }
  
  /** 
   * Une classe interne pour gerer la fermeture de la fenetre
   */
  class FermeurDeFenetre extends WindowAdapter {
    public void windowClosing(WindowEvent event){
      setVisible(false);
    }
  }
}





