
//////////////////////////////////////////////////
//          Jeu de Morpion Tetedechat V0        //
//         Classe PlanJeu pour le client        //
//////////////////////////////////////////////////




//Declaration des imports
import java.awt.*;
import java.awt.event.*;


/** <B>Caracteristiques :</B><BR>
* 
* Classe graphique representant l'echiquier.
* 
* @author Audrey Sanz-Vella
* @author Alexandre Martin
* @see Client
* @see MorpionGraphique
* @see BoiteTeleportation
* @see BoiteRejouer
* @see PlanFin
* @see JavaMorpiaudAide
*/

//Declaration de la classe  graphique du jeu
public class PlanJeu extends Canvas implements MouseListener{

   
    //Declaration des variables
    private MorpionGraphique monMorpionGraphique;
 
    private int nbJoueurs;
    private int nbCases;
    
    private Image image;

    private boolean initialisationPlanJeu=true;
   
    private int hauteur;
    private int largeur;

   
    


    /** Constructeur du PlanJeu.<BR>
     * il affiche une image de fond, un quadrillage et attend les clics de souris
     * @param<code>monMorpionGraphique</code> represente l'instance de la classe MorpionGraphique qui appelle PlanJeu.
     * @param<code>nbJoueurs</code> represente le nombre de joueurs pour la parite en cours. Cela permet de determiner le nombre de cases a afficher.
     */

    //Constructeur de la classe
    public PlanJeu(MorpionGraphique monMorpionGraphique,int nbJoueurs){

        //Recuperation des parametres
        this.monMorpionGraphique=monMorpionGraphique;
        this.nbJoueurs=nbJoueurs;
        
        //Ajoute un ecouteur de souris au plan de jeu
        addMouseListener(this);

        //Calcul du nombre de cases
        this.nbCases = this.nbJoueurs + this.nbJoueurs - 1;
             
    }//Fin Constructeur







   
    /** Methode initialisant une image de fond pour le canvas.*/ 

    //Methode d'initialisation de l image de fond
    public void initialisationImageFond(){

        image=createImage(this.getSize().width,this.getSize().height);
        Graphics g = image.getGraphics();
        g.drawImage(monMorpionGraphique.getImageFond(),0,0,this.getSize().width,this.getSize().height,this);
        //Misa a jour de la variable initialisationPlanJeu
        initialisationPlanJeu = false;
    
    }//Fin de la methode initialisationImageFond
    







  /** Methode reecrivant la methode paint du canvas.<BR>
   * Elle reecrit sur l'image de fond et y ajoute un quadrillage.
   * @param<code>g</code> element graphique.
   */ 

 //Reecriture de la methode paint pour afficher le canvas
    public void paint (Graphics g) {
        
        //Cas ou le plan de jeu n'existe pas encore visuellement
        if (initialisationPlanJeu==true){
           
            initialisationImageFond();
        }

        g.drawImage(image,0,0,this.getSize().width,this.getSize().height,this);
   
            //recuperation de la largeur et de la longueur des cases
            largeur=this.getSize().width/nbCases;
            hauteur=this.getSize().height/nbCases;

            // Quadrillage
            g.setColor(Color.yellow); 
            for(int i=0;i<nbCases;i++) {
                System.out.println(i);
                g.drawLine(0,i*hauteur,this.getSize().width,i*hauteur);
                g.drawLine(i*largeur,0,i*largeur,this.getSize().height);
            }// fin for
        
    }//Fin de la methode paint









    /** Methode reecrivant la methode update du canvas.<BR>
     * @param<code>g</code> element graphique.
     */ 
   
    //Reecriture de la methode paint pour afficher le canvas
    public void update(Graphics g) {

        paint(g);
    
    }// fin de la methode update
    








    /** Methode utilisee pour gerer les evenements des mouselistener.
     * @param <code>MouseEvent</code> evenement de souris.
     */

    //Methode grant les evenements de type clic de souris
    public void mouseClicked(MouseEvent e){
        
        //Cas ou c'est bien le tour du joueur, on regarde si la case est libre
        if(monMorpionGraphique.getMonClient().getJoueurTour()==true){
            
            //Demande au serveur un traitement sur la case specifique
            monMorpionGraphique.getMonClient().getCaseLibre(getCaseX(e.getX())+3,getCaseY(e.getY())+3);
        }
        else{
            
            //Cas ou ce n'est pas le tour du joueur
            monMorpionGraphique.afficherMessage("Eh ! Tu peux pas attendre ton tour comme tout le monde ?!!!");
        }//Fin du else

    }//Fin de la methode mouseClicked


    /** Methode vide.*/
    public void mouseEntered(MouseEvent e){}
    /** Methode vide.*/
    public void mousePressed(MouseEvent e){}
    /** Methode vide.*/
    public void mouseExited(MouseEvent e){}
    /** Methode vide.*/
    public void mouseReleased(MouseEvent e){}









    /////////////////////////////////////////////////////////////////////
    // Accesseurs
    /////////////////////////////////////////////////////////////////////


    /** Accesseur permettant de recuperer la largeur d une case.*/

    //Methode permettant de recuperer la largeur d une case
    public int getLargeurCase(){
        return image.getWidth(this)/nbCases;
    
    }//Fin de la methode getLargeurCase
   

    /** Accesseur permettant de recuperer la hauteur d une case.*/

    //Methode permettant de recuperer la hauteur d une case
    public int getHauteurCase(){
    
        return image.getHeight(this)/nbCases;
   
    }//Fin de la methode getHauteurCase
    

    /** Accesseur permettant d'acceder a l image de fond. */

    //Methode permettant d'acceder a l image de fond
    public Image getImage(){

        return this.image;
    
    }//Fin de la methode getImage
   

    /** Accesseur permettant de determiner la colonne choisie.
     * @param<code>x</code> definit le numero de la colonne clique
     */

    //Methode permettant de determiner la case X
    public int getCaseX(int x){

        return x/largeur;

    }//Fin de la methode getCaseX

    /** Accesseur permettant de determiner la ligne choisie.
       * @param<code>y</code> definit le numero de la colonne clique
           */
//Methode permettant de determiner la case X
    public int getCaseY(int y){

        return y/hauteur;
    
    }//Fin de la methode getCaseY
    


}// fin class PlanJeu








