
//////////////////////////////////////////////////
//          Jeu de Morpion Tetedechat V0        //
//         Classe PlanFin pour le client        //
//////////////////////////////////////////////////




//Declaration des imports
import java.awt.*;
import java.awt.event.*;



/** <B>Caracteristiques :</B><BR>
* 
* Classe graphique representant la fin du jeu.
* 
* @author Audrey Sanz-Vella
* @author Alexandre Martin
* @see Client
* @see MorpionGraphique
* @see BoiteTeleportation
* @see BoiteRejouer
* @see PlanJeu
* @see JavaMorpiaudAide
*/

//Declaration de la classe affichant un message de fin de partie
public class PlanFin extends Canvas {

   
    //Declaration des variables
    private MorpionGraphique monMorpionGraphique;
 
    private String nomJoueur;
    private int numeroEvenement;
    private Image image;
    private boolean init=true;
    private Font font;



    /** Constructeur du PlanFin.<BR>
     * il affiche une image de fond et attend les clics de souris
     * @param<code>monMorpionGraphique</code> represente l'instance de la classe MorpionGraphique qui appelle PlanFin.
     * @param<code>nomJoueur</code> represente le nom du joueur gagnant.
     * @param<code>numeroEvenement</code> represente le type d'evenement a afficher.
     */

    //Constructeur de la classe
    public PlanFin(MorpionGraphique monMorpionGraphique,String nomJoueur,int numeroEvenement){

        //Recuperation des parametres
	this.monMorpionGraphique=monMorpionGraphique;
	this.nomJoueur=nomJoueur;
	this.numeroEvenement=numeroEvenement;

	//Ajout d'un MouseEvent qui permettra de sortir de cette fenetre
	addMouseListener(new MouseAdapter(){
	    public void mouseClicked(MouseEvent me){
		//Lorsqu'on clique, lea fenetre du gagnant est detruite et 
		//la configuration deconnecte reapparait
		removeNotify();
	    }//Fin de la methode MouseClicked
	}//Fin de la classe MouseAdapter
			 );
    
    }//Fin Constructeur




    /** Methode initialisant une image de fond pour le canvas.*/ 

    //Methode initialisant une image vide
    public void init(){

        //Creation d'une image vide qui servira de base
        image=createImage(monMorpionGraphique.getSize().width,this.getSize().height);
    }







    /** Methode reecrivant la methode paint du canvas.<BR>
     * Elle reecrit sur l'image de fond et y ajoute du texte.
     * @param<code>g</code> element graphique.
     */ 

    //Reecriture de la methode paint pour afficher le canvas
    public void paint(Graphics g) {
     
	if (init==true){
	init();
	init=false;
	}
	//Recuperation de l'image dans une variable Graphics
	//g = image.getGraphics();


	//Ajout sur cette image d'une nouvelle image
	g.drawImage(monMorpionGraphique.getImageFin(),0,0,monMorpionGraphique.getSize().width,this.getSize().height,this);

	//Definit la font et la couleur d'affichage
	g.setFont(new Font("Courier",Font.BOLD, 20));
	g.setColor(Color.yellow);

	//Etude des variables nomJoueur et numeroEvenement
	//Cas ou il n'y a plus de cases libres sur l'echiquier
	if ((nomJoueur.equals("nul"))&&(numeroEvenement==7)){

            g.drawString("Vous etes tous mauvais !!!",(((this.getSize().width)/2)-((26*14)/2)),100);  
            g.drawString("Y a plus de cases libres !!!",(((this.getSize().width)/2)-((28*14)/2)),250); 
	}

	//Cas ou il n'y a plus assez de joueurs pour continuer la partie
	else if((nomJoueur.equals("nul"))&&(numeroEvenement==8)){
	  
            g.drawString("Un client vient de se deconnecter !",(((this.getSize().width)/2)-((35*16)/2)),100);  
            g.drawString("Y a plus assez de joueurs ...",(((this.getSize().width)/2)-((29*16)/2)),250);
	}
	
	//Cas ou un joueur gagne vraiment
	else{
	    g.drawString(nomJoueur,(((this.getSize().width)/2)-((nomJoueur.length()*17)/2)),100);

	    //Redefinit la font et la couleur d'affichage
	    g.setFont(new Font("TimesRoman",Font.BOLD, 20));
	    g.setColor(Color.red);

	    g.drawString("vous a bien eu....",(((this.getSize().width)/2)-((18*10)/2)),250);
	}
	   
    }//Fin de la methode paint




    /** Methode reinitialisant les menus et variables du client.
     * @param<code>etat</code> definit l'etat du jeu.
     */ 

    //Methode permettant de reinitialiser la fenetre graphique principale
    public void setJeu(boolean etat){

	monMorpionGraphique.setJeu(false);

    }//Fin de la methode setJeu




}// fin class PlanFin








