 

//////////////////////////////////////////////////
//          Jeu de Morpion Tetedechat V0        //
//                 Classe Client                //
//////////////////////////////////////////////////




//Declaration des imports
import java.awt.*;
import java.rmi.*;
import java.rmi.server.*;
import java.awt.event.*;


/** <B>Caracteristiques :</B><BR>
* 
* Classe principale du client.<BR>C'est elle qui cree le client graphique et qui est en relation avec le serveur.
* 
* @author Audrey Sanz-Vella
* @author Alexandre Martin
* @see Serveur
* @see MorpionGraphique
* @see BoiteTeleportation
* @see BoiteRejouer
* @see PlanJeu
* @see PlanFin
* @see JavaMorpiaudAide
*/



//Declaration de la classe Client local
public class Client extends UnicastRemoteObject implements ClientDistant{
    

    //Declaration des variables
    private MorpionGraphique monMorpionGraphique;
    private MorpionDistant morpion;

    private boolean initialisationRMIManager;
    private boolean connexion;
    private String reponseServeur="attente";

    private String nomServeur;
    private String nomClient;
    private boolean joueurTour=false;






    /** Constructeur du client.*/

    //Constructeur de la classe
    public Client() throws RemoteException{

      //Initialisation des variables responsables des connexions
          initialisationRMIManager=true;
          connexion=false;

          //Instanciation de l'interface graphique
          monMorpionGraphique=new MorpionGraphique(this);
   
    }//Fin Constructeur
 





    /** Methode principale permettant de lancer l'application.
     * <BR>
     * Elle cree une nouvelle instance de cette classe.*/

    //Methode principale
    public static void main (String args []) {

        try{
            //Construit un nouveau client
          Client monClient=new Client();
       
        }//Fin du try
        catch(Exception e){
            e.printStackTrace();
            System.out.println("Le client n a pas pu etre instancie.");
        }

    }//Fin methode principale






    /** Methode utilisee pour se connecter au serveur.
     * <BR>
     * Elle envoit tout d'abord un message au serveur puis enregistre le client sur celui-ci.
     * @param <code>nomClient</code> Nom du client.
     * @param <code>nbJoueurs</code> Nombre de joueurs potentiel pour la partie
     */

    //Methode Servant a etablir une connection
    public void connexion(String nomClient, int nbJoueurs){
        
        try {
           
            //Cas ou le RMISecurityManager n'est pas actif
            if (initialisationRMIManager==true){
                
                //Creation d'un RMISecurityManager
                System.setSecurityManager(new RMISecurityManager());

                //redefinition de la variable initialisationConnexion
                initialisationRMIManager=false;
                
            }//Fin de la boucle if

            //Creation d'un objet distant morpion
            morpion = (MorpionDistant) Naming.lookup ("rmi://"+nomServeur+"/morpion");

            //La connexion est realisee
            connexion=true;

            //Test
            monMorpionGraphique.afficherMessage("En voiture s il vous plait !!! Direction le serveur !!!");
            morpion.afficherStringServeur("Serveur Clio, TERMINUS, tout le monde descend !!!");
            
            //Ajout du client dans le tableau Vector du serveur
            monMorpionGraphique.afficherMessage("Attendez moi, Attendez moi, j suis toujours un peu en retard...");
            morpion.enregistrerClient(this,nomClient,nbJoueurs);
         
        }//Fin du try
        catch(UnknownHostException uhe){
           
            monMorpionGraphique.afficherMessage("Je crois que vous vous etes trompes dans les coordonnees du serveur.");
            connexion=false;
            monMorpionGraphique.setJeu(false);
            return;
        }
        
        catch(Exception e){
            e.printStackTrace();
            connexion=false;
            monMorpionGraphique.setJeu(false);
        }//Fin du catch

    }//Fin methode connection
  






    /** Methode permettant d'afficher le jeu par le serveur lorsque tous les joueurs sont connectes.
     * 
     * @param <code>nbJoueurs</code> Nombre de joueurs definitif pour la partie (utilise pour definir le nombre de cases sur l'echiquier).
     */

    //Methode pour faire afficher le planjeu
    public void afficherMorpion(int nbJoueurs) throws RemoteException{

        monMorpionGraphique.afficherJeu(nomClient,nbJoueurs);
    
    }//Fin de la methode afficherMorpion








    /** Methode permettant d'effectuer le traitement sur le serveur de la case choisie par le joueur.
     * 
     * @param <code>caseX</code> numero de la colonne choisie.
     * @param <code>caseY</code> numero de la ligne choisie.
     */

    //Methode permettant de regarder sur le serveur si une case est libre
    public void getCaseLibre(int caseX,int caseY){

        try{

            //Regarde sur le serveur si la case choisie est jouable et gagnante
            morpion.getCaseLibre(caseX,caseY);

        }//Fin du try
        catch(Exception e){
            e.printStackTrace();
            System.out.println("Probleme d'execution de la methode getCaseLibre");
            monMorpionGraphique.problemeConnexion();
        }

    }//Fin de la methode getCaseLibre







    /** Methode utilisee pour afficher un pion.
     * @param <code>numeroJoueur</code> Numero du pion a afficher.
     * @param <code>caseX</code> numero de colonne
     * @param <code>caseY</code> numero de ligne
     */

    //Methode permettant d'afficher un pion en fonction de la case et du numero du joueur
    public void afficherMorPion(int numeroJoueur, int caseX, int caseY) throws RemoteException{
        
        //Affiche le pion joue
        monMorpionGraphique.afficherMorPion(numeroJoueur,caseX,caseY);

    }//Fin de la methode afficherMorPion







    /** Methode utilisee pour afficher des informations du serveur sur le client
     * par l'intermediaire de la zone de texte.
     * @param <code>message1</code> chaine de caracteres a afficher.
     */

    //Methode d affichage de donnees accessible au serveur
    public void afficherStringClient(String message1) throws RemoteException{

        monMorpionGraphique.afficherMessage(message1);
    
    }//Fin de la moethode afficherStringClient


     /** Methode utilisee pour afficher des informations du serveur sur le client
     * par l'intermediaire de la zone de texte.
     * @param <code>message1</code> premiere chaine de caracteres a afficher.
     * @param <code>nombre</code> nombre a afficher.
     * @param <code>message2</code> seconde chaine de caracteres a afficher.
     */

    //Methode d affichage de donnees accessible au serveur
    public void afficherStringClient(String message1,int nombre, String message2) throws RemoteException{
        
         monMorpionGraphique.afficherMessage(message1,nombre,message2);
    
    }//Fin de la moethode afficherStringClient


    /** Methode utilisee pour afficher des informations du serveur sur le client
     * par l'intermediaire de la zone de texte.
     * @param <code>message1</code> premiere chaine de caracteres a afficher.
     * @param <code>message2</code> seconde chaine de caracteres a afficher.
     */

    //Methode d affichage de donnees accessible au serveur
    public void afficherStringClient(String message1,String message2) throws RemoteException{
        
        monMorpionGraphique.afficherMessage(message1,message2);
    
    }//Fin de la methode afficherStringClient








    
    /** Methode permettant de reinitialiser le client en fin de partie.
     * @param <code>nomJoueurGagnant</code> definit un joueur gagnant.
     * @param <code>numeroEvenement</code> definit un type d'evenement.
     * @param <code>message2</code> seconde chaine de caracteres a afficher.
     */

    //Methode permettant de stopper une partie et de reinitialiser le client
    public void setFinPartie(String nomJoueurGagnant, int numeroEvenement) throws RemoteException{

        monMorpionGraphique.afficherJoueurGagnant(nomJoueurGagnant, numeroEvenement);

    }//Fin de la methode setFinPartie


    /** Methode permettant de reinitialiser le client en fin de partie lorsqu'il n'y a qu'un joueur connecte*/

   //Methode permettant de stopper une partie et de reinitialiser le client
    public void setFinPartie() throws RemoteException{

        monMorpionGraphique.setJeu(false);

    }//Fin de la methode setFinPartie






    /** Methode permettant d'envoyer des messages aux autres utilisateurs.
     * @param <code>message</code> definit le message a envoyer.
     */

    //Methode permettant de dialoguer avec les autres utilisateurs
    public void chat(String message){
        
        //Envoie au serveur le message et le nom de son proprietaire
        try{

            morpion.chat(this.nomClient,message);

              }//Fin du try
        catch(Exception e){
            System.out.println("Probleme d'execution de la methode chat");
            monMorpionGraphique.problemeConnexion();
        }

    }//Fin de la methode chat






    /** Methode permettant de deconnecter le client sur le serveur.*/

    //Methode permettant de deconnecter le client
    public void deconnecterClient(){

        try{

            morpion.deconnecterClient(nomClient);

        }//Fin du try
        catch(Exception e){
            System.out.println("Probleme d'execution de la methode deconnecterClient");
            monMorpionGraphique.problemeConnexion();
        }

    }//Fin de la methode deconnecterClient










    ////////////////////////////////////////////////////////////////////////////////////////
    //Accesseurs
    ////////////////////////////////////////////////////////////////////////////////////////


   /** Accesseur pour nom du serveur.
    * @param <code>nomServeur</code> nom du serveur a definir.
    */

    //Methode definissant le nom du serveur
    public void setNomServeur(String nomServeur){
       
        this.nomServeur=nomServeur;

    }//Fin de la methode setNomServeur


     
    /** Accesseur definissant le nom du client.
     * @param <code>nomClient</code> Nom du client a definir.
     */

    //Methode definissant le nom du client
    public void setNomClient(String nomClient){
       
        this.nomClient=nomClient;
    
    }//Fin de la methode setNomClient



    /** Accesseur definissant si c'est le tour du joueur.
    * @param <code>joueurTour</code> Etat du tour a definir.
    */

    //Methode definissant si c'est le tour du joueur
    public void setJoueurTour(boolean joueurTour) throws RemoteException{

        this.joueurTour=joueurTour;

    }//Fin de la methode setJoueurTour



    /** Accesseur definissant la reponse du serveur durant la connection.*/

    //Methode definissant la reponse du serveur durant la connection
    public void setReponseServeur(String reponse) throws RemoteException{
        
        this.reponseServeur=new String(reponse);
    
    }//Fin de la methode setReponseServeur


    /** Accesseur definissant l'etat de la connexion.*/

   //Methode definissant l'etat de la connexion
    public void setConnexion(boolean connexion){
        
        this.connexion=connexion;
    
    }//Fin de la methode setConnexion





    /** Accesseur permettant d'obtenir le tour du joueur.*/

    //Methode permettant d'obtenir le tour du joueur
    public boolean getJoueurTour(){

        return this.joueurTour;
    
    }//Fin de la methode getJoueurTour


    /** Accesseur pour obtenir la reponse du serveur concernant la connexion.*/

   //Methode pour obtenir la reponse du serveur concernant la connexion
    public String getReponseServeur(){
        
        return this.reponseServeur;
    
    }//Fin de la methode getReponseServeur

   

    /** Accesseur pour obtenir l'etat de la connexion.*/

    //Methode pour obtenir l'etat de la connexion
    public boolean getConnexion(){
        
        return this.connexion;
    
    }//Fin de la methode getConnexion

    
    
    //Methode pour savoir si c'est la premiere connexion
    public boolean getInitialisationRMIManager(){
        
        return this.initialisationRMIManager;
    
    }//Fin de la methode getInitialisationRMIManager




}//Fin de la classe Client



