//////////////////////////////////////////////////
//          Jeu de Morpion Tetedechat V0        //
//               Classe BoiteRejouer            //
//////////////////////////////////////////////////




//Declaration des imports
import java.awt.*;
import java.awt.event.*;



/** <B>Caracteristiques :</B><BR>
* 
* Classe affichant une boite de dialogue de connexion allegee (nom du joueur, nombre de joueurs).
* 
* @author Audrey Sanz-Vella
* @author Alexandre Martin
* @see Client
* @see MorpionGraphique
* @see BoiteTeleportation
* @see PlanJeu
* @see PlanFin
* @see JavaMorpiaudAide
*/

//Declaration de la classe BoiteRejouer
public class BoiteRejouer extends Dialog implements ActionListener {



  //Declarations des variables

    private MorpionGraphique monMorpionGraphique;
    private GridBagLayout grille= new GridBagLayout();
    private GridBagConstraints alignement=new GridBagConstraints();
    private Label nomServeur;
    private Label NomJoueurLabel;
    private Label nbJoueurs;
    private TextField nomDuServeur;
    private TextField nomDuJoueur;
    private Choice nbDuJoueurs;
    private Button go;
    private Button annuler;
    protected PlanJeu planJeu;
    



    /** Constructeur de la Boiteteleportation.
     * @param<code>fenetrePrincipale</code> represente l'instance de la classe MorpionGraphjique qui appelle BoiteTeleportation.
     */

  //Constructeur de la classe
  public BoiteRejouer(MorpionGraphique fenetrePrincipale){
      
      //Cree une nouvelle fenetre pour la boite de dialogue
      super(fenetrePrincipale,"Allez Hop !!! Une Autre Partie ...",false);

      //Recupere les parametres
      monMorpionGraphique=fenetrePrincipale;

      //Personnalise la fenetre creee
      super.setBackground(Color.white);
    
   //Definition d une grille afin de placer des elements dans la fenetre
   //L affichage sera de type GridBagLayout
   setLayout(grille);
   
   //Definition de chaque composant de la grille,   
   NomJoueurLabel= new Label("Votre nom :");
   rangerItems(NomJoueurLabel,0,0,1,1);
 
   nomDuJoueur= new TextField(30);
   nomDuJoueur.setBackground(Color.gray);
   rangerItems(nomDuJoueur,1,0,1,1);
  
 //Ajoute un keyEvent pour la fenetre
   nomDuJoueur.addKeyListener(new KeyAdapter(){
       public void keyReleased(KeyEvent ke){
	   if(ke.getKeyCode()==KeyEvent.VK_ENTER){
	       traiterBoiteRejouer();
	   }
       }//Fin de la methode keyReleased
   }//Fin de la classe KeyAdapter
       );

   nbJoueurs= new Label("Choisissez un nombre de joueurs :");
   rangerItems(nbJoueurs,0,1,1,1);
  
   nbDuJoueurs= new Choice();
   nbDuJoueurs.add("2");
   nbDuJoueurs.add("3");
   nbDuJoueurs.add("4");
   nbDuJoueurs.add("5");
   nbDuJoueurs.add("6");
   rangerItems(nbDuJoueurs,1,1,1,1);
  
   go= new Button("GO!");
   alignement.anchor=GridBagConstraints.EAST;
   alignement.fill=GridBagConstraints.BOTH;
   rangerItems(go,2,0,1,1);
   go.addActionListener(this);
  
   annuler= new Button("ANNULER");
   alignement.anchor=GridBagConstraints.EAST;
   alignement.fill=GridBagConstraints.BOTH;
   rangerItems(annuler,2,1,1,1); 
   annuler.addActionListener(this);

   //Ajoute un windowEvent pour la fenetre
   addWindowListener(new WindowAdapter(){
       public void windowClosing (WindowEvent we){
           dispose();
       }//Fin de la methode windowClosing
   }//Fin de la classe WindowAdapter
                     );

   //Permet de dimensionner la fenetre a la taille de ce qu elle contient et l'affiche
   pack();
   setVisible(true);

  }//Fin Constructeur




    /** Methode positionnant les elements de la boites.
     * @param<code>composant</code> nom du composant a placer.
     * @param<code>gridxs</code> point de depart X du composant.
     * @param<code>gridys</code> point de depart Y du composant.
     * @param<code>gridwidths</code> longueur du composant.
     * @param<code>gridheights</code> largeur du composant.
     */ 

    //Methode permettant d incorporer des items dans la grille plus facilement
    public void rangerItems(Component composant,int gridxs,int gridys,int gridwidths,int gridheights){
       
        alignement.gridx=gridxs;
        alignement.gridy=gridys;
        alignement.gridwidth=gridwidths;
        alignement.gridheight=gridheights;
        grille.setConstraints(composant,alignement); 
        add(composant);
    }






    /** Methode utilisee pour gerer les evenements des actionlistener.
     * @param <code>ActionEvent</code> evenement d'action.
     */

    //Methode de traitement des evenements
    public void actionPerformed(ActionEvent e){
  
        if (e.getSource()==annuler){

            this.dispose();
        
        }else if (e.getSource()==go){
            
            traiterBoiteRejouer();
        }//Fin du else

    }//Fin de la methode actionPerformed








   /** Methode realisant les traitements sur la boite de dialogue.*/

    //Methode realisant le traitement des champs de la boite de dialogue
    public void traiterBoiteRejouer(){

        //Recupere les donnees passees en parametres
        String tempNomClient=nomDuJoueur.getText();

        //Cas ou rien n'est inscrit
        if (tempNomClient.equals("")){
            
            monMorpionGraphique.afficherMessage("***** Il vous manque une case peut etre ??? *****");
            this.dispose();
        }
        else{
            
            //Bloque les boutons de la boite de dialogue
            go.setEnabled(false);
            annuler.setEnabled(false);


            //Met a jour la variable nomClient
            monMorpionGraphique.getMonClient().setNomClient(tempNomClient);

            //Realise un essai de connexion
            monMorpionGraphique.getMonClient().connexion(tempNomClient,Integer.parseInt(this.nbDuJoueurs.getSelectedItem()));
                
            //Traitement de la reponse
            if (monMorpionGraphique.getMonClient().getConnexion()==false){
              
                monMorpionGraphique.afficherMessage("La connection s est encore plante lamentablement...");
                monMorpionGraphique.setJeu(false);
                this.dispose();    
            }
            
            //Cas ou la connexion est faite
            else{

                //Cas ou le serveur est plein
                if (monMorpionGraphique.getMonClient().getReponseServeur().equals("Pleing")){
                    monMorpionGraphique.afficherMessage("Trop de monde...Desole !! :)");
                    monMorpionGraphique.setJeu(false);
                    this.dispose();
                }
                
                //Cas ou on attend d'autres joueurs
                else if (monMorpionGraphique.getMonClient().getReponseServeur().equals("attente")){
                    monMorpionGraphique.setJeu(true);
                    this.dispose();
                 }

            }//Fin du cas ou la connexion est realisee
            
        }//Fin du cas ou les champs sont remplis
        
    }//Fin de la methode traiterBoiteRejouer
  




}//Fin de la classe BoiteRejouer













