package pacman;

import java.awt.*;
import java.util.* ;
/**
 * C'est la que s'affiche le decor.
 */
public class MonPacCanvas extends java.awt.Canvas {
	/**
	  * Vecteur des lments graphiques  redessiner au prochain rafraichissement.
	  */
	private Vector elementsAReDessiner ;
	
	/**
	  * hauteur du canvas en pixels.
	  */
	private int hauteur ;

	/**
	  * largeur du canvas en pixels.
	  */
	private int largeur ;
	
	/**
	  * Image pour le double buffer.
	  */ 
	private Image buffer ;

	/**
	  * Graphics sur le double buffer.
	  */
	private Graphics gb ; 
/**
 * Constructeur de base.
 */
public MonPacCanvas(int hauteur, int largeur) {
	super() ;
	elementsAReDessiner = null ;
	this.hauteur = hauteur ;
	this.largeur = largeur ;
}
/**
 * Gestion des dimensions du canvas.
 * @return java.awt.Dimension
 */
public Dimension getMaximumSize() {
	return getMinimumSize() ;
}
/**
 * Gestion des dimensions du canvas.
 * @return java.awt.Dimension
 */
public Dimension getMinimumSize() {
	return new Dimension(largeur, hauteur) ;
}
/**
 * Gestion des dimensions du canvas.
 * @return java.awt.Dimension
 */
public Dimension getPreferredSize() {
	return getMinimumSize() ;
}
/**
 * Raffraichissement du canvas, avec double buffer.
 * @param g Graphics
 */
public void paint(Graphics g) 
{
	for (Enumeration e = elementsAReDessiner.elements() ; e.hasMoreElements() ;) 
		((ObjetGraphique )e.nextElement()).dessineToi(gb) ;

	// Recopie du double buffer
	g.drawImage(buffer, 0, 0, this) ;

}
/**
 * Cette mthode est utilis par la MaPacFrame pour transmettre au canvas le double buffer qu'elle a cre.<br>
 * En effet, la methode getImage de Canvas retourne null !!
 * @param buffer java.awt.Image
 */
public void setDoubleBuffer(Image buffer) {
	this.buffer = buffer ;
	if (this.buffer == null) System.out.println("MonPacCanvas : Double buffer null") ;
	gb = buffer.getGraphics() ;
	if (this.gb == null) System.out.println("MonPacCanvas : gb null") ;
}
/**
 * Cette mthode est utilise par le GameManager pour grern les rafraichissements d'cran.
 * @param v java.util.Vector
 */
public void setelementsAReDessiner(Vector v) {
	elementsAReDessiner = v ;
}
/**
 * Surcharge de update : On n'efface plus avant paint car cela ne sert  rien. 
 */
public void update(Graphics g) {
	paint(g) ;
}
}