package pacman;

import java.awt.* ;
import java.awt.event.* ;
import java.util.* ;
import java.lang.Math.* ;
/**
 * Les fantomes poursuivent le pacman si superPacman est false, et le mangent si ils le rattrapent.
 * Ils contiennent leurs reprsentations graphiques qui changes suivant l'etat du pacman.
 * L'attribut direction sert au thread a poursuivre le mouvement et tester s'il n'y a pas de mur devant.
 */
public class Fantome extends Mobile implements Runnable {
	/**
	  * La cible des fantomes.
	  */
	private static Pacman pacman ;  

	/**
	  * Sprite du Fantome peureux. (peut se faire manger par pacman)
	  */
	static private Image fantomePeureux      = getImage("fantvert.gif") ;

	/**
	  * Sprite du Fantome qui va repartir en chasse.
	  */
	static private Image fantomeMoinsPeureux = getImage("fantorange.gif") ;

	/**
	  *	Sprite du Fantome en chasse. (peut manger le pacman)
	  */
 	static private Image fantomeAffame       = getImage("fantrouge.gif") ;

 	/**
 	  * Sprite courant.
 	  */
	static private Image sprite ;

	/**
	  * Vitesse d'evolution de fantomes. (Plus ce nombre est faible, plus ils vont vite.)
	  */
	static private int vitesseFantome ;                                      

	/**
	  * La direction du fantome.
	  */
	private Direction direction ;  
/**
 * Constructeur par dfaut.
 */
public Fantome(int x, int y, Pacman pacman) {
	super(x, y) ;
	this.pacman = pacman ;
	direction = stop ;
	sprite = fantomeAffame ;
	vitesseFantome = 300 ;
}
/**
 * This method was created in VisualAge.
 */
public static void accelere() 
{
	if (vitesseFantome > 0) vitesseFantome -= 25 ;
}
/**
 * Pour l'instant, les fantomes ne font que poursuivre.
 */
private Direction calculDirection(Position positionPacman) 
{
	Direction []direction = new Direction[4] ;
	int cx = positionPacman.getx() - x ;
	int cy = positionPacman.gety() - y ;
	
	/*** Algorithme de poursuite ***/
	// Si le Pacman est en SuperForme, On le fuit...
	if(superPacman) { cx = -cx ; cy = -cy ; }
	
	// On determine la priorite des 4 directions (direction[0] est la plus proritaire et direction[3] la moins)
	if ((cx == 0) && (cy == 0)) direction[0] = stop ;
	else
	  if (Math.abs(cx) > Math.abs(cy))
		{
		 	if (cx > 0) { direction[0] = bas ; direction[3] = haut ; }
		    else { direction[0] = haut ; direction[3] = bas ; }
		 	if (cy > 0) { direction[1] = droite ; direction[2] = gauche ; }
		 	else { direction[1] = gauche ; direction[2] = droite ; }
		}
	  else
		{
			if (cx > 0) { direction[1] = bas ; direction[2] = haut ; }
		    else { direction[1] = haut ; direction[2] = bas ; }
		 	if (cy > 0) { direction[0] = droite ; direction[3] = gauche ; }
		 	else { direction[0] = gauche ; direction[3] = droite ; }
		}


	// On determine la direction la plus prioritaire qui ne pointe pas une brique.
	boolean sortie = false ;
	int i = -1 ;
	int new_x = x, new_y = y ; 
	do
	{
		i++ ;
		if (direction[i] == haut)        { new_x = x-1 ; new_y = y   ; }
		else if (direction[i] == bas)    { new_x = x+1 ; new_y = y   ; }
		else if (direction[i] == gauche) { new_x = x   ; new_y = y-1 ; }
		else if (direction[i] == droite) { new_x = x   ; new_y = y+1 ; }

		if ((decor.getElementDuDecor(new_x, new_y).getClass().getName()).compareTo("pacman.Brique") != 0)
			sortie = true ;
	} while(sortie == false) ;

	if(i>3) System.out.println("Fantome.calculDirection : Cas Impossible...") ;
	return direction[i] ;
}
/**
 * deplaceToi method comment.
 */
public void deplaceToi(Direction d) 
{
	int new_x = x , new_y = y ;

	if (d == haut) { new_x = x-1   ; new_y = y ; }
	else if (d == bas)    { new_x = x+1  ; new_y = y ; }
	else if (d == gauche) { new_x = x  ; new_y = y-1 ; }
	else if (d == droite) { new_x = x    ; new_y = y+1 ; }
	else if (d == stop)   { new_x = x    ; new_y = y   ; }

	// Verifie si le mouvement est legale (Pas de mur)
	if ((decor.getElementDuDecor(new_x, new_y).getClass().getName()).compareTo("pacman.Brique") != 0)
		{
			x = new_x ;
			y = new_y ;
			if(getPosition().isSame(pacman.getPosition()))  {  
 				if (superPacman) { System.out.println("Fantome : ME SUIS FAIS MANGER !!!") ; }    // Ne doit jamais arriver ici. ( Pacman.deplaceToi()) 
 				else mangePacman() ;      }       // Miam Miam....
			
//			System.out.println("Element : "+decor.getElementDuDecor(new_x, new_y).getClass().getName()) ;
//			System.out.println("Nouvelle Position : "+x+", "+y) ;
		}
		else System.out.println("Fantome : Y'A UN MUR") ;
}
/**
 * This method was created in VisualAge.
 */
public void dessineToi(java.awt.Graphics g) {
	g.drawImage(sprite, spriteSize*y, spriteSize*x, null) ;
}
/**
 * This method was created in VisualAge.
 */
public void mangePacman() {
	if (pacman.isDead()) ; // Il vient d'etre manger par un autre fantome
	else pacman.mort() ;   // Sinon On le mange
	
}
/**
 * This method was created in VisualAge.
 */
private void mort() {
	reset() ;
}
/**
 * This method was created in VisualAge.
 */
public void run() {
	try {
		Thread.currentThread().sleep(1000);
		while (true) {
			// Gestion du sprite du fantome.
			if (superPacman)
				if (pacman.getsuperPuissance() > 15)
					sprite = fantomePeureux;
				else
					sprite = fantomeMoinsPeureux;
			else
				sprite = fantomeAffame;

			// Gestion des Deplacements
			direction = calculDirection(pacman.getPosition());
			if (direction != stop)
				deplaceToi(direction);
			Thread.currentThread().sleep(vitesseFantome);
		}
	} catch (InterruptedException e) {
		System.out.println("Fantome Run : InterruptedException Thrown from run.");
		e.printStackTrace();
	}
}
/**
 * This method was created in VisualAge.
 * @param pacman pacman.Pacman
 */
public static void setPacman(Pacman pacman) {
	Fantome.pacman=pacman ;
}
}