package pacman;

import java.awt.* ;
import java.awt.event.* ;
import java.util.* ;
/**
 * Pour l'instant, il ne fait que se deplacer. (il ne mange pas) ;
 * Le Pacman : <UL>
 * <li>KeyListener : Pour pouvoir etre diriger par le joueur avec les touches.<\li>
 * <li>Runnable : Pour que le Pacman ait un mouvement propre.</UL>
 */
public class Pacman extends Mobile implements KeyListener, Runnable {
	/**
	  * Sert  la Gestion de l'animation (Bouche ouverte, ferm...)
	  */
	private int etat=1;                // Etat des sprites
	
	/**
	  * Nombre de vies restants au pacman 
	  */
	private int vie=3 ;

	/**
	  * score du pacman ( PacGum +1,  SuparPacGum +10, Fantome +25)
	  */
	private int score = 0 ;

	/**
	  * Sert au GameManager pour rinitialiser le jeu a la mort du pacman
	  */
	private boolean mort = false ;

	/**
	  * Compteur de SuperPuissance restant au pacman
	  */
	private int superPuissance = 0 ;
	
	private Direction direction ;

	/**
	  * Ce sont les fantomes qui poursuivre le pacman : On a besoin de connaitre leur position pour les manger.
	  */ 
	private Vector fantomesVecteur ;


	/**
	  * Les sprites utiliss pour l'animation du pacman
	  */
	private Image[] image ;
	private Image image_droite[] = new Image[4] ;
	private Image image_gauche[] = new Image[4] ;
	private Image image_haut[]   = new Image[4] ;
	private Image image_bas[]    = new Image[4] ;
	private Image sprite;
	
	
/**
 * Constructeur usuel.
 * @param x int
 * @param y int
 */
public Pacman(int x, int y) {
	super(x, y);
	direction = stop ;
	fantomesVecteur = new Vector(8, 4) ;
	
	// Chargement des images
	for (int i = 0; i < 4; i++) 
		{
			image_droite[i] = getImage("pacman"+(i+1)+"d.gif") ;
			image_gauche[i] = getImage("pacman"+(i+1)+"g.gif") ;
			image_haut[i]   = getImage("pacman"+(i+1)+"h.gif") ;
			image_bas[i]    = getImage("pacman"+(i+1)+"b.gif") ;
		}
	image = image_droite ;
}
/**
 * Rajoute un poursuivant au pacman
 * @param fantome pacman.Fantome
 */
public void addFantome(Fantome fantome) {
	fantomesVecteur.addElement(fantome) ;
}
/**
 * Cette methode est creer pour le GameManager pour gerer les vies bonus.
 */
public void addpoint() {
	score++ ;
}
/**
 * Tous les 250 pts, on gagne une vie. (utilis par la GameManager)
 */
public void bonusVie() {
	vie++ ;
}
/**
 * deplaceToi fait plusieurs choses :<ul>
 * <li>Teste si le dplacement est valide (Pas de mur).</li>
 * <li>Assure la gestion des repas. (PacGum et SuperPacGum).</li>
 * <li>Teste si on mange des fantomes.</li></ul>
 */
public void deplaceToi(Direction d) {
	int new_x = x , new_y = y ;

	if (d == haut) {        new_x = x-1 ; new_y = y   ; image = image_haut   ; }
	else if (d == bas)    { new_x = x+1 ; new_y = y   ; image = image_bas    ; }
	else if (d == gauche) { new_x = x   ; new_y = y-1 ; image = image_gauche ; }
	else if (d == droite) { new_x = x   ; new_y = y+1 ; image = image_droite ; }
	else if (d == stop)   { new_x = x   ; new_y = y   ; }

	// Verifie si le mouvement est legale (Pas de mur)
	if ((decor.getElementDuDecor(new_x, new_y).getClass().getName()).compareTo("pacman.Brique") != 0)
		{
			x = new_x ;
			y = new_y ;
			// Si on arrive sur une PacGum on la mange.
			if ((decor.getElementDuDecor(new_x, new_y).getClass().getName()).compareTo("pacman.PacGum") == 0)
				mangeGum() ;
			
			// Si on arrive sur une SuperPacGum, on la mange et gare aux fantomes.
			if ((decor.getElementDuDecor(new_x, new_y).getClass().getName()).compareTo("pacman.SuperPacGum") == 0)
				mangeSupePacGum() ;
			
			// Si on arrive sur un fantome ... on doit normalement le manger (sinon c'est un suicide).
			Fantome fantome ;
			for (Enumeration e = fantomesVecteur.elements() ; e.hasMoreElements() ;)
				{
					fantome = (Fantome )e.nextElement() ;
					if(getPosition().isSame(fantome.getPosition()) && superPacman)
						mangeFantome(fantome) ;
					else ;// Si t'es pas superPacman t'es mal...	
				}
		}
	
}
/**
 * Dessin du pacman
 */
public void dessineToi(Graphics g) {
	g.drawImage(sprite, spriteSize*y, spriteSize*x, null) ;	
}
/**
 * Retourne le score courant.
 * @return int
 */
public int getscore() {
	return score ;
}
/**
 * Retourne ce qui reste de superPuissance du pacman
 * @return int
 */
public int getsuperPuissance() {
	return superPuissance ;
}
/**
 * Retourne le nombre de vies restantes
 * @return int
 */
public int getvie() {
	return vie ;
}
/**
 * Le pacman est mort ? (utilise par GameManager)
 * @return boolean
 */
public boolean isDead() {
	return mort ;
}
/**
 * Gestion du clavier pour diriger le pacman.
 * @param e KeyEvent
 */
public void keyPressed(KeyEvent e) {
	// On ne se sert que de keyTyped
}
/**
 * Gestion du clavier pour diriger le pacman.
 * @param e KeyEvent
 */
public void keyReleased(KeyEvent e) {
	// On ne se sert que de keyTyped
}
/**
 * Gestion du clavier pour diriger le pacman.
 * @param e KeyEvent
 */
public void keyTyped(KeyEvent e) {
	switch (e.getKeyChar())
	{
		case '8' : direction = haut   ; break ;
		case '2' : direction = bas    ; break ;
		case '4' : direction = gauche ; break ;
		case '6' : direction = droite ; break ;
		case '5' : direction = stop   ; break ;
	}
}
/**
 * Quand on mange un fantome. 
 * @param fantome pacman.Fantome
 */
private void mangeFantome(Fantome fantome) {
	score += 25 ;
	fantome.reset() ;
}
/**
 * Quand on mange une PacGum.
 */
public void mangeGum() {
	decor.setElementDuDecor(x,y,new Sol(x,y)) ;
	score++ ;
}
/**
 * Quand on mange une SuperPacGum
 */
public void mangeSupePacGum() {
	decor.setElementDuDecor(x,y,new Sol(x,y)) ;
	score += 10 ;
	superPacman = true ;
	superPuissance = SuperPacGum.getpuissance() ;
}
/**
 * Quand il est mort.
 */
public void mort() {
	x = x_init ;
	y = y_init ;
	vie-- ;
	mort = true ;
}
/**
 * Utiliser pour les rinitialisations.
 */
public void reset() {
	super.reset() ;
	mort = false ;
}
/**
 * Vie du pacman : Deplacement et animation.
 */
public void run() {
	while(true)
	{
		try 
		{
			Thread.currentThread().sleep(50);
		}
		catch (InterruptedException e) 
		{
			System.out.println("Pacman Run : InterruptedException Thrown from run.");
			e.printStackTrace();
		}
		
		// Gestion de l'animation du Pacman.
		switch (etat % 4)
		{
			case 0 : sprite = image[0];
			break;
			case 1 : sprite = image[1];
			break;
			case 2 : sprite = image[2];
			break;
			case 3 : sprite = image[3];
			break;
		}
		etat++;

		// Gestion du super etat du Pacman
		superPuissance-- ;
		if (superPuissance == 0)
			superPacman = false ;

		// Gestion des Deplacements		
		if (direction != stop) deplaceToi(direction) ;
		try
		{
			Thread.currentThread().sleep(100) ;
		}
		catch (InterruptedException e)
		{
			System.out.println("Pacman Run : InterruptedException Thrown from run.") ;
			e.printStackTrace() ;
		}
	}
}
}