package pacman;

import java.awt.* ;
/**
 * Type commun donnant la position des objets graphiques.
 * toolkit sert  rcuprer les images les reprsentants.
 * Il doivent avoir une taille de 23x23 pixels
 */
abstract public class ObjetGraphique {
	/**
	  * Sert a charger les sprites pour tous les ObjetGraphique.
	  */
	static private Toolkit toolkit = Toolkit.getDefaultToolkit() ;

	/**
	  * Tout objet graphique a une taille de 23x23 pixels
	  */
	static protected int spriteSize = 23 ;                          

	/**
	  * numero de ligne de l'ObjetGraphique dans le Decor.
	  */
	protected int x;

	/**
	  * numero de colonne de l'ObjetGraphique dans le Decor.
	  */
	protected int y;
/**
 * Constructeur initialisant les positions x et y.
 * @param x int
 * @param y int
 */
public ObjetGraphique(int x,int y) {
	this.x=x;
	this.y=y;
}
/**
 * Mthode abstraite permettant  l'objet graphique de se dessiner.
 */
public abstract void dessineToi(Graphics g);
/**
 * Sert a charger les sprites
 * @return java.awt.Image
 */
static protected Image getImage(String spriteFileName) {
	return toolkit.getImage(spriteFileName) ;
}
/**
 * Retourne la position de l'ObjetGraphique.
 * @return pacman.Position
 */
public Position getPosition() {
	return new Position(x, y);
}
/**
 * Accesseur de l'attribut x.
 * @return int
 */
public int getx() {
	return x;
}
/**
 * Accesseur de l'attribut y.
 * @return int
 */
public int gety() {
	return y;
}
/**
 * Modifieur de l'attribut x.
 */
public void setx(int x) {
	this.x=x;
}
/**
 * Modifieur de l'attribut y
 */
public void sety(int y) {
	this.y=y;
}
}