package pacman;

import java.awt.* ;
import java.util.* ;
/**
 * Classe abstraite des lments dplaables.
 * Tous les objets Mobile ont en commun les quatres direction qu'ils peuvent suivre.
 * Tous les objets Mobile ont en commun le decor de maniere a ne pas se deplacer dans les murs.
 * L'attribut static superPacman indique aux fantomes si il faut fuir ou pas.
 */
abstract public class Mobile extends ObjetGraphique {
	/**
	  * Les mobiles connaissent le decor pour pouvoir se deplacer
	  */
	static protected Decor decor ;
	
	/**
	  * Definition de la direction <i>vers le haut<\i>.
	  */
	static Direction haut   = new Direction() ;

	/**
	  * Definition de la direction <i>vers le bas<\i>.
	  */
	static Direction bas    = new Direction() ;

	/**
	  * Definition de la direction <i>vers la gauche<\i>.
	  */
	static Direction gauche = new Direction() ;

	/**
	  * Definition de la direction <i>vers la droite<\i>.
	  */
	static Direction droite = new Direction() ;
	
	/**
	  * Definition de la direction <i>stop<\i>.
	  */
	static Direction stop   = new Direction() ;

	/**
	  * Indicateur de SuperPacman : true -> Pacman peut manger les fantomes.
	  */
	static boolean superPacman = false ;

	/**
	 * Sert aux rinitialisations du jeu.
	 */
	int x_init, y_init ;
	
/**
 * This method was created in VisualAge.
 * @param x int
 * @param y int
 */
public Mobile(int x, int y) {
	super(x, y) ;
	x_init = x ;
	y_init = y ;
}
/**
 * Permet a l'objet mobile de se dplacer.
 */
public abstract void deplaceToi(Direction d);
/**
 * This method was created in VisualAge.
 */
public static Decor getDecor() {
	return decor ;
}
/**
 * This method was created in VisualAge.
 */
public void reset() {
	x = x_init ;
	y = y_init ;
}
/**
 * This method was created in VisualAge.
 * @param decor pacman.Decor
 */
public static void setDecor(Decor decor) {
	Mobile.decor = decor ;
}
}