package pacman;

import java.util.* ;
import java.awt.event.* ;
import java.awt.* ;
/**
 * C'est le type de la fenetre de jeu.
 */
public class MaPacFrame extends java.awt.Frame {
	/**
	  * C'est l que sont affichs tous les lments graphiques.
	  */ 
	private MonPacCanvas canvas ;

	/**
	  * Double buffer. (crer par MaPacFrame car le canvas renvoie null)
	  */
	private Image buffer;  // Le Canvas est incapable de creer une image !!

	/**
	 * Affichage du score.
	 */
	private Label label1 = new Label() ;   // Score

	/**
	  * Affichage du nombre de vies restantes.
	  */
	private	Label label2 = new Label() ;   // Nonbre de vies

	/**
	  * Affichage des mssages.
	  */
	private Label label3 = new Label() ;   // Messages

	/**
	  * Contient les Labels.
	  */
	private Panel panel  = new Panel() ;

	/**
	  * C'est le GameManager qui a cr cette MaPacFrame.<br>
	  * Cette attribut permet de lui appliquer la mthode stop() quand on ferme la Frame.
	  */
	private GameManager father ;

	/**
	  * Ferme la fenetre quand on clique sur la croix
	  */
	private class MonWindowClosing extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			father.stop() ;         // On arrette tous les Threads.
			dispose();
			System.exit(0);
		}
	}
/**
 * Constructeur.<br>
 * largeur et hauteur servent  creer le double buffer (ne peut etre creer par le canvas)
 */
public MaPacFrame(MonPacCanvas canvas, KeyListener pacman, int largeur, int hauteur, GameManager father) {
	super("Pacman");
	this.father = father ;
	this.canvas = canvas ;
	setLayout(new BorderLayout());
	panel.setLayout(new GridLayout(0, 3)) ;
	add("South",panel);
	label1.setBackground(Color.lightGray) ;
	label1.setText("Score : 00000") ;
	label2.setBackground(Color.lightGray) ;
	label2.setText("Vie(s) : ") ;
	label3.setBackground(Color.lightGray) ;
	label3.setText("                  ") ;
	panel.add(label1) ;
	panel.add(label3) ;
	panel.add(label2) ;
	add("North",canvas) ;
	canvas.addKeyListener(pacman) ;
	addWindowListener(new MonWindowClosing()) ;
	pack() ;
	show() ;
	setResizable(false) ;
	System.out.println("On a cree une image") ;
	Image buffer = createImage(largeur+100, hauteur+100) ;
	if(buffer==null) System.out.println("MaPacFrame : CA CHIE !!!!!!!!!!!!!!!!!") ;
	canvas.setDoubleBuffer(buffer) ;

}
/**
 * Permet le rafraichissement de l'ecran. (Utilis par l'intermediaire du GameManager)
 */
public void refresh() {
	canvas.repaint() ;
}
/**
 * Modifieur de canvas.
 * @param canvas pacman.MonPacCanvas
 */
public void setCanvas(MonPacCanvas canvas) {
	this.canvas = canvas ;
}
/**
 * Utiliser par le GameManager pour le rafraichissement de l'cran.
 * @param elementsAReDessiner Vector
 */
public void setElementsAReDessiner(Vector elementsAReDessiner) {
	canvas.setelementsAReDessiner(elementsAReDessiner) ;
}
/**
 * Gestion de l'affichage des messages.
 * @param message java.lang.String
 */
public void setMessage(String message) {
	label3.setText(message) ;
}
/**
 * Gestion de l'affichage du score.
 * @param score int
 */
public void setScore(int score) {
	label1.setText("Score : "+score) ;
}
/**
 * Gestion de l'affichage du nombre de vies restantes.
 * @param score int
 */
public void setVie(int vie) {
	label2.setText("Vie(s) : "+vie) ;
}
}