package pacman;

import java.util.* ;

/**
 * C'est le gestionnaire du jeu. Ses fonctions sont :<UL>
 * <li> Tester la fin du jeu.<\li>
 * <li> Tester si la pacman  t mang et rinitialiser le jeu.<\li>
 * <li> Determiner les ElementsDuDecor et des mobiles qui sont  redessiner.<\li>
 * <li> Faire redessiner MonPacCanvas.<\li>
 * <li> Attribuer une nouvelle vie au pacman tous les 250 points.<\li>
 * <li> Acclrer les fantomes  intervalle de temps rgulier.<\li><\UL>
 */
public class GameManager implements Runnable {

	/**
	  * Le hro du jeu
	  */
	private Pacman pacman ;

	/**
	  * Les fantomes qui poursuivent le pacman.
	  */ 
	private Vector fantomesVecteur ;

	/**
	  * Le dcor dans lequel Pacman et les fantomes voluent.
	  */
	private Decor decor ;

	/**
	  * La Fenetre d'affichage du jeu.
	  */
	private MaPacFrame fenetreDeJeu ;

	/**
	  * Groupe des Threads qui animent les mobiles.
	  */
	private ThreadGroup lesMobiles ;

	/**
	  * Thread qui fait fonctionner le GameManager.
	  */
	private Thread gmThread ;

	/**
	  * Nombre de PacGum restantes  manger (Pour tester la fin du jeu et calculer a chaque tour par setDecor()).
	  */
	private int pacGumRestantes ;

	/**
	  * Intervalle de temps entre chaque tours du GameManager.
	  */
	static int tempsEntreFrames = 100 ;
/**
 * Constructeur.<ul>
 * <li> nbFantomes : nombre de fantomes dans le jeu.<\li>
 * <li> posInitialeX : numro des lignes des positions initiales des fantomes. <\li>
 * <li> posInitialeY : numro des colonnes des positions initiales des fantomes. <\li>
 * <li> decor : Decor d'volution des mobiles.
 */
public GameManager(int nbFantomes, int[] posInitialeX, int[] posInitialeY, Decor decor) 
{
	Fantome newFantome ;
	
	lesMobiles = new ThreadGroup("Les Mobiles") ;

	pacman = new Pacman(9,9) ;
	(new Thread(lesMobiles, pacman, "pacman")).start() ;
	
	fantomesVecteur = new Vector(nbFantomes) ;     // Creation des fantomes (POSITION A SPECIFIER)
	for(int i=0; i<nbFantomes; ++i)
	{
		newFantome = new Fantome(posInitialeX[i], posInitialeY[i], pacman) ;
		fantomesVecteur.addElement(newFantome) ;
		pacman.addFantome(newFantome) ;
		(new Thread(lesMobiles, newFantome, "fantome"+i)).start() ;
	}
			
		 
	Mobile.setDecor(decor) ;                       // Fixe le decor pour les mobiles
	this.decor = decor ;                           // Fixe le decor pour le GM (encore utile ?)
	
	
	int size = ObjetGraphique.spriteSize ;
	int largeur = decor.gethauteur()*size ;
	int hauteur = decor.getlargeur()*size ;
	fenetreDeJeu = new MaPacFrame(new MonPacCanvas(largeur, hauteur), pacman, largeur, hauteur, this) ;

	// Sert a gerer les affichages
	gmThread = new Thread(this) ;
	gmThread.start() ;
}
/**
 * C'est l que toute les actions du GameManager sont effectues.
 */
public void run() {
	try
	{
		int compteur = 0 ;
		Thread.currentThread().sleep(1000) ;
		while(true)
		{
			compteur++ ;
			// Rafraichissement du decor
			setDecor() ;
			decor = Mobile.getDecor() ;
			// Si Pacman est mort : on reinitialise le jeu ;
			if (pacman.isDead()) 
				if (pacman.getvie() > 0)
				{
					pacman.reset() ;
					for (Enumeration e = fantomesVecteur.elements() ; e.hasMoreElements() ;)
						((Fantome )e.nextElement()).reset() ;
					lesMobiles.suspend() ;
					Thread.currentThread().sleep(1000) ;
					lesMobiles.resume() ;
				}
				else
				{
					lesMobiles.stop() ;
					fenetreDeJeu.setMessage("Vous tes mort !!!!") ;
					fenetreDeJeu.repaint() ;
				}
			else if (pacGumRestantes == 0)    // Pacman a gagne !
				 {
					lesMobiles.stop() ;
					fenetreDeJeu.setMessage("Flicitation !!!!") ;
					fenetreDeJeu.repaint() ;
				 }
			if ((compteur % 100) == 0) Fantome.accelere() ;          // On accelere les fantomes de temps en temps
			if ((pacman.getscore() % 250) == 0)                      // On rajoute une vie au pacman tous les 250 pts
				{
					pacman.bonusVie() ;
					pacman.addpoint() ;    // On rajoute un point pour que le pacman ne gagne qu'une seule vie.
				} ;
			Thread.currentThread().sleep(tempsEntreFrames) ;
		}
	}
	catch (InterruptedException e)
		{
			System.out.println("GameManager Run : InterruptedException Thrown from run.") ;
			e.printStackTrace() ;
		}
}
/**
 * Sert a l'affichage.
 */
public void setDecor() {
	pacGumRestantes = 0 ;
	int hauteur = decor.gethauteur() ;
	int largeur = decor.getlargeur() ;
	Vector elementsAReDessiner = new Vector(hauteur*largeur) ;

	ElementDuDecor element ;
	for(int i=0; i<hauteur; ++i)
		for(int j=0; j<largeur; ++j)
		{
			element = decor.getElementDuDecor(i, j) ;
			if ((element.getClass().getName()).compareTo("pacman.PacGum") == 0)
				pacGumRestantes++ ;
			elementsAReDessiner.addElement(element) ;
		}			

	elementsAReDessiner.setElementAt(pacman, pacman.getx()*largeur+pacman.gety()) ;

	for (Enumeration e = fantomesVecteur.elements() ; e.hasMoreElements() ;) 
		elementsAReDessiner.addElement(e.nextElement()) ;

	fenetreDeJeu.setScore(pacman.getscore()) ;
	fenetreDeJeu.setVie(pacman.getvie()) ;
	fenetreDeJeu.setElementsAReDessiner(elementsAReDessiner) ;
	fenetreDeJeu.refresh() ;
}
/**
 * Fin de jeu.
 */
public void stop() {
	lesMobiles.stop() ;
	gmThread.stop() ;
}
}