package pacman;

/**
 * Type des diffrents niveaux de jeu.<br>
 * C'est le plan du monde dans lequel Pacman et les Fantomes volues.<br>
 * Il est exclusivement composer d'ElementDuDecor.
 */
public class Decor {
	/**
	  * Plan du niveau de jeu.
	  */
	private ElementDuDecor decor[][];

	/**
	  * Hauteur du decor en nombre de sprites
	  */
	private int hauteur;

	/**
	  * Largeur du decor en nombre de sprites.
	  */
	private int largeur;
/**
 * Constructeur usuel.
 * @param longueur int
 * @param largeur int
 * @param decor pacman.ElementDuDecor[][]
 */
public Decor(int hauteur,int largeur) {
	this.hauteur=hauteur;
	this.largeur=largeur;
	this.decor=new ElementDuDecor[hauteur][largeur] ;
}
/**
 * Constructeur usuel.
 * @param longueur int
 * @param largeur int
 * @param decor pacman.ElementDuDecor[][]
 */
public Decor(int hauteur,int largeur,ElementDuDecor decor[][]) {
	this.hauteur=hauteur;
	this.largeur=largeur;
	this.decor=new ElementDuDecor[hauteur][largeur] ;
	for (int i=0;i<hauteur;++i)
		for (int j=0;j<largeur;++j)
			this.decor[i][j]=decor[i][j] ;		
}
/**
 * Retourne l'ElementDuDecor  la i-me ligne et j-me colonne du Decor.
 * @return pacman.ElementDuDecor
 * @param i int
 * @param j int
 */
public ElementDuDecor getElementDuDecor(int i, int j) {
	return decor[i][j] ;
}
/**
 * Retourne l'ElmentDuDecor situ  la Position position du decor.
 * @return pacman.ElementDuDecor
 * @param i int
 * @param j int
 */
public ElementDuDecor getElementDuDecor(Position position) {
	return decor[position.getx()][position.gety()] ;
}
/**
 * Retourne la hauteur du decor en nombre de sprites.
 * @return int
 */
public int gethauteur() {
	return hauteur ;
}
/**
 * Retourne la largeur du decor en nombre de sprites.
 * @return int
 */
public int getlargeur() {
	return largeur;
}
/**
 * Fixe l'ElementDuDecor  la i-me ligne et j-me colonne du decor.<br>
 * Utilis pour remplacer les PacGum et SuperPacGum par des Sol quand elles ont t manges.
 * @param i int
 * @param j int
 * @param e pacman.ElementDuDecor
 */
public void setElementDuDecor(int i, int j, ElementDuDecor e) {
	decor[i][j] = e ;      // faudrait gerer les index hors tableaux.
}
}