// **********************
// *** Telechargement ***
// **********************

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.net.*;
import java.io.*;

/**
 * La classe Telechargement telecharge le fichier situe  l'URL indique
 *
 * @author Bruno GERY
 * @version Version 1.00
 */
public class Telechargement implements Runnable
{
	private Thread thread = null;
	private ThreadGroup threadGroup = null;
	private EntiteURL entiteURL = null;
	private Vector telechargementListeners = null; // Vecteur contenant les Listeners a prevenir.
	private String path = "";
	private int bufSize = 10000;
	private TelechargementEvent evt;
	
	/*
	 * Construit un nouvel objet telechargement
	 */
	public Telechargement(EntiteURL entiteURL, String path, ThreadGroup threadGroup)
		{
			this.entiteURL = entiteURL;
			this.path = path;
			this.threadGroup = threadGroup;
			telechargementListeners = new Vector();
			evt = new TelechargementEvent(this,entiteURL,TelechargementEvent.DONE);
		} // Telechargement()
	
	public void init()
		{
			
		}
	
	public void start()
		{
			if ( thread == null )
				{
					thread = new Thread(threadGroup,this);
					thread.start();
				}
		}
	
	public void run()
		{
			lireURL(entiteURL.getURL());
			notifyTelechargementEvent();
		}
	
	// ******************************
	// *** Gestion des evenements ***
	// ******************************
	public synchronized void addTelechargementListener(TelechargementListener l)
		{
			// On ajouter le recepteur s'il n'y est pas deja.
			if ( !telechargementListeners.contains(l) )
				telechargementListeners.addElement(l);
		} // addRequeteListener()
	
	public synchronized void removeTelechargementListener(TelechargementListener l)
		{
			// On retire le recepteur s'il y est.
			if ( telechargementListeners.contains(l) )
				telechargementListeners.removeElement(l);
		} // removeRequeteListener()
	
	protected void notifyTelechargementEvent()
		{
			int i, n;
			Vector v;
			TelechargementListener recepteur;
			
			// Recopie du vecteur pour qu'il ne puisse etre modifie.
			synchronized(this)
				{
					v = (Vector) telechargementListeners.clone();
				}
			
			// On declenche l'evenement vers tous les recepteurs
			n = v.size();
			for ( i = 0 ; i < n ; i++ )
				{
					recepteur = (TelechargementListener) v.elementAt(i);
					recepteur.telechargementPerformed(evt);
				}	
		} // notifyTelechargementEvent()
	
	/*
	 * Methode qui lit le fichier texte (HTML) situe  URL.
	 *
	 *@return Retourne le fichier lu sour forme de String<BR>
	 * Et null si le fichier n'a pu etre lu
	 */
	public boolean lireURL(URL url)
		{
			BufferedInputStream fluxIn = null;
			BufferedOutputStream fluxOut = null;
			int c;
			int nb;
			byte buffer[] = new byte[bufSize];
			URLConnection connexion;
			long volume = 0;
			
			try
				{
					connexion = url.openConnection();
					entiteURL.setMimeType(connexion.getContentType());  // Recuperation du MimeType.
					fluxIn = new BufferedInputStream(connexion.getInputStream(),bufSize);
					// fluxIn = new BufferedInputStream(url.openStream(),bufSize);
					fluxOut = creerFichier();
					if ( fluxOut == null )
						{
							entiteURL.incErreur();
							evt.setResultat(TelechargementEvent.FAIL);
							return(false);
						}
				}
			catch (Exception ex)
				{
					System.out.println("Pas pu ouvrir l'URL : "+url);
					entiteURL.incErreur();
					evt.setResultat(TelechargementEvent.FAIL);
					return(false);
				}
			// Ouverture correctement effectuee => Lire
			try
				{
					do
						{
							c =  fluxIn.read(buffer,0,bufSize);
							if ( c > 0 )
								{
									volume = volume + c;
									fluxOut.write(buffer,0,c);
								}
						}
					while ( c != -1 );
					// Fermeture des flux.
					fluxIn.close();
					fluxOut.close();
					// Tout s'est deroule normalement :
					entiteURL.setTelecharged(true);
				}
			catch (IOException ex)
				{
					evt.setResultat(TelechargementEvent.FAIL);
					return(false);
				}
			evt.setVolume(volume);
			
			return(true);
		} // lireURL()
	
	public BufferedOutputStream creerFichier()
		{
			BufferedOutputStream fluxOut = null;
			String nomFichier = "";
			URL url = entiteURL.getURL();
			int i = 1;
			
			nomFichier = path+url.getHost()+url.getFile();
			// Traitement des URL sans fichier : .../toto/ => On cree un index.html par defaut.
			if ( nomFichier.charAt(nomFichier.length() - 1) == '/' )
				nomFichier = nomFichier + "index.html";
			File file = new File(nomFichier);
			// Si un fichier de meme nom existe deja on renomme avec .1, puis .2, ...
			while ( file.exists() )
				{
					file = new File(nomFichier+"."+i);
					i++;
				}
			// Pour s'assurer que tous les dossiers sont cree.index.html
			file.mkdirs();
			file.delete();
			try
				{
					fluxOut = new BufferedOutputStream(new FileOutputStream(file),bufSize);
					if ( fluxOut == null )
						{
							System.out.println("Pas pu creer le fichier : "+file.getAbsolutePath());
							return(null);
						}
				}
			catch ( IOException ex)
				{
					System.out.println("Pas pu creer le fichier : "+file.getAbsolutePath());
					return(null);
				}
			
			entiteURL.setFile(file);
			return(fluxOut);
		}
	
	public URL getURL()
		{
			return(entiteURL.getURL());
		}
	
} // Telechargement.



