// ********************************
// *** PiocheurDeTelechargement ***
// ********************************

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.undo.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.LineBorder;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;

/**
 * Cette classe pioche dans une ListeEntiteURL, des elements  telecharger.
 * Elle lance alors des Telechargements (Thread) sur ces elements.
 *
 * @see Telechargement
 * @author Bruno GERY
 * @version Version 1.00
 */
public class PiocheurDeTelechargement implements TelechargementListener, Runnable, ActionListener
{
	private Thread thread = null;  // La Thread PiocheurDeTelechargement.
	private ThreadGroup groupeDeTelechargement = null;  // Groupe des Telechargement en cours.
	Parseur parseur, parseur2;

	private int nbMaxTelechargement = 1;
	private boolean sortirDuDomaine = false;  // Ne pas sortir du domaine
	private String path = "";  // Dossier ou les fichiers telecharges doivent etre sauver.
	private ListeEntiteURL listeEntiteURL;
	private boolean piocher = true;  // Indique s'il faut continuer a piocher des elements a telecharger !
	
	// Statistiques :
	private int nbTelechargementOK = 0 , nbTelechargementKO = 0;
	private long volume = 0;
	
	// Partie Interface graphique :
	FenetreDeTelechargement panel;
	
	public PiocheurDeTelechargement(ListeEntiteURL listeEntiteURL, int nbMaxTelechargement, boolean sortirDuDomaine, String path)
		{

			this.listeEntiteURL = listeEntiteURL;
			this.nbMaxTelechargement = nbMaxTelechargement;
			this.path = path;
			groupeDeTelechargement = new ThreadGroup("Groupe de Telechargement");
			
			this.sortirDuDomaine = sortirDuDomaine;
			
			// Creer une fenetre Telechargement :
			
			panel = new FenetreDeTelechargement(listeEntiteURL,listeEntiteURL.getURL().toString());
			panel.boutStop.addActionListener(this);
			panel.boutReprendre.addActionListener(this);
			panel.boutFermer.addActionListener(this);
			panel.boutSauver.addActionListener(this);
			
			panel.ouvrirFenetre();
			
		}
	
	public void actionPerformed(ActionEvent evt)
    {
      JButton bout;
      
      if ( evt.getSource() instanceof JButton )
				{
					bout = (JButton) evt.getSource(); 
					if ( bout == panel.boutStop )
						{
							//panel.setStat(nbTelechargementOK,nbTelechargementKO,volume);
							stop();
						}
					if ( bout == panel.boutFermer )
						{
							panel.closeFenetre();
						}
					if ( bout == panel.boutReprendre )
						{
							panel.reprendre();
							piocher = true;
							this.start();
						}
					if ( bout == panel.boutSauver )
							{
									sauverListe();
							}
				}
    } // actionPerformed()
	
	public void start()
		{
			//if ( thread == null )
			//	{
					thread = new Thread(this);
					thread.start();
			//	}
		}
	
	public void stop()
		{
			parseur.stop();
			parseur2.stop();
			piocher = false;
			//groupeDeTelechargement.stop();
		}
	
	public void run()
		{
			EntiteURL e = null;
			int cpt = 0;  // Compteur de demande de Telechargelment infructueuse
			int maxCpt = 5;  // Nb de demande infructueuse qui incite a croire que c'est fini.
			int nbTelechargement = 0;  // Le nombre de telechargement en cours
			
			// On lance un parseur :
			parseur = new Parseur(listeEntiteURL,sortirDuDomaine);
			parseur.start();
			parseur2 = new Parseur(listeEntiteURL,sortirDuDomaine);
			parseur2.start();
			while ( piocher )//i < 7 )
				{
					nbTelechargement = groupeDeTelechargement.activeCount();
					if ( nbTelechargement >=  nbMaxTelechargement )
						{
							try { Thread.sleep(20); } catch (Exception ex) { System.out.println("Trop de thread :"+e); }
							continue;
						}
					e = listeEntiteURL.getElementToTelecharge();
					if ( e == null )
						{
							if ( nbTelechargement == 0 ) cpt++;  // Pas la peine d'incrementer si un telechargement en cours.
							try { Thread.sleep(100); } catch (Exception ex) { System.out.println("Exception Sleep dans PiocheurDeTelechargement:"+e); }
						}
					else
						{
							cpt = 0;  // Remise a 0 du compteur puis un de trouve !
							panel.addList(""+e.getURL());
							Telechargement telechargement = new Telechargement(e,path,groupeDeTelechargement);
							telechargement.addTelechargementListener(this);
							telechargement.start();
						}
					if ( cpt > maxCpt )
						{
							if ( nbTelechargement == 0 && cpt > maxCpt+2 && !parseur.isParsing() && !parseur2.isParsing() && listeEntiteURL.nothingToDo() )
								stop();  // On refait le test 2 fois avant de conclure definitivement ( cpt > maxCpt+2 ).
						}
				} // While
			
			// Attendre la fin des telechargements en cours avant de Stopper.
			while ( groupeDeTelechargement.activeCount() > 0 )
				{
					try { Thread.sleep(500); } catch (Exception ex) { System.out.println(ex); }
				}
			// Afficher les statistiques :
			panel.setStat(nbTelechargementOK,nbTelechargementKO,volume);
			panel.showTree();
		}
	
	public void telechargementPerformed(TelechargementEvent evt)
		{
			Telechargement t;
			
			t = (Telechargement) evt.getSource();
			panel.removeList(""+t.getURL());
			switch ( evt.getResultat() )
				{
				case TelechargementEvent.DONE:
					nbTelechargementOK++;
					volume = volume+evt.getVolume();
					break;
				case TelechargementEvent.FAIL:
					nbTelechargementKO++;
					break;
				}
			panel.setStat(nbTelechargementOK,nbTelechargementKO,volume);
		}
		
		public boolean sauverListe()
		{
			ObjectOutputStream fluxOut = null;
			String nomFichier = "liste.obj";
			
			FileDialog selecteur = new FileDialog(panel.frame, "Sauver telechargement",FileDialog.SAVE);
			selecteur.show();
			// Vrification de selection :
			nomFichier = selecteur.getFile();
			if ( nomFichier == null )  return(false);
			// Pour s'assurer que tous les dossiers sont cree.index.html
			
			File file = new File(nomFichier);
			file.mkdirs();
			file.delete();
			try
				{
					fluxOut = new ObjectOutputStream(new FileOutputStream(file));
					if ( fluxOut == null )
						{
							System.out.println("Pas pu creer le fichier : "+file.getAbsolutePath());
							return(false);
						}
					fluxOut.writeObject(listeEntiteURL);
					fluxOut.close();
				}
			catch ( IOException ex)
				{
					System.out.println("Pas pu creer le fichier : "+file.getAbsolutePath());
					return(false);
				}
			
			return(true);
		}
	 
} // Piocheur()



