/* ******************** */
/* *** Parseur.java *** */
/* ******************** */

import java.io.*;
import java.util.Vector;
import java.net.URL;
import adc.parser.*;

/**
 * Classe ralisant le parsing d'une l'EntiteURL de MimeType text/html
 */
public class Parseur implements Runnable
{
	Thread thread = null;
	EntiteURL entiteURL;
	ListeEntiteURL lst;  // Liste contenant les URLs trouve a ajouter dans la liste principale.
	ListeEntiteURL listeEntiteURL;  // La liste principale des EntiteURL a telecharger.
	String txt = "";
	private boolean parsing = false; // Indique si un fichier est en train d'etre parse !
	private boolean sortirDomaine = false;
	
	public Parseur(ListeEntiteURL listeEntiteURL, boolean sortirDomaine)
		{
			this.entiteURL = entiteURL;
			this.listeEntiteURL = listeEntiteURL;
		}
	
	public void start()
		{
			if ( thread == null )
				{
					thread = new Thread(this);
					thread.start();
				}
		}
	
	public void run()
		{
			while ( true )
				{
					entiteURL = listeEntiteURL.getElementToParse();
					if ( entiteURL == null )
						try { Thread.sleep(20); } catch (Exception ex) { System.out.println("Pas pu faire de Sleep dans Parseur !"); }
					else
						{
							parsing = true;
							parser();
							parsing = false;
						}
				}
		}
	
	public void stop()
		{
			thread = null;
		}
	
	public synchronized boolean isParsing()
		{
			return(parsing);
		}
	
	public void parser()
		{
			if ( chargerFichier() )
				if ( rechercheTousLesLinks() )
					{
						
					}
				else
					System.out.println("Ouverture mais pas parsing");
			else
				System.out.println("Meme pas d'ouverture pour parsing");
		}
	
	public boolean chargerFichier()
		{
			File file;
			int bufSize = 10000;
			BufferedInputStream fluxIn;
			byte buffer[] = new byte[bufSize];
			int c;
			
			if ( entiteURL.getMimeType().compareTo("text/html") != 0 )  return(false);
			file = entiteURL.getFile();
			if ( !file.exists() )  return(false);
			
			try
				{
					// Ouverture du fichier :
					fluxIn = new BufferedInputStream(new FileInputStream(file),bufSize);
					if ( fluxIn == null )  return(false);
					// Lecture et conversion en texte :
					txt = "";
					do
						{
							c =  fluxIn.read(buffer,0,bufSize);
							if ( c > 0 )
								{
									txt = txt + new String(buffer,0,c);
								}
						}
					while ( c != -1 );
				}
			catch (Exception ex)
				{
					System.out.println("Erreur en ouverture du fichier par le Parseur !");
				}
			
			return(true);
		}
	
	public boolean rechercheTousLesLinks()
		{
			StringBufferInputStream stream = new StringBufferInputStream(txt);
			HtmlStreamTokenizer tok = new HtmlStreamTokenizer(stream);
			HtmlTag tag = new HtmlTag();
			String ch;
			String base = "";  // En cas de base HREF
			int tokType;
			int tagType;
			Vector links = new Vector();
			
			String typeDeTag = "";
			
			// Rechercher tousles liens vers images, fichiers, pages html, ...
			try
				{
					while (tok.nextToken() != HtmlStreamTokenizer.TT_EOF)
						{
							tokType = tok.getTokenType();
							if ( tokType == HtmlStreamTokenizer.TT_TAG )
								{
									try
										{
											ch = null;
											typeDeTag = "";
											
											tok.parseTag(tok.getStringValue(), tag);
											tagType = tag.getTagType();
											
											if ( tagType == HtmlTag.T_BASE )		// Tag BASE HREF=...
												{
													base = tag.getParam(HtmlTag.P_HREF);
												}
											
											if ( tagType == HtmlTag.T_EMBED )		// Tag EMBED SRC=...
												{
													ch = tag.getParam(HtmlTag.P_SRC);
													typeDeTag = "T_EMBED";
												}
											if ( tagType == HtmlTag.T_FRAME )		//Tag BASE FRAME=...
												{
													ch = tag.getParam(HtmlTag.P_SRC);
													typeDeTag = "T_FRAME";
												}
											if ( tagType == HtmlTag.T_A )		//Tag A HREF=...
												{
													ch = tag.getParam(HtmlTag.P_HREF );
													typeDeTag = "T_A";
												}
											if ( tagType == HtmlTag.T_IMG )		//Tag <IMG SRC="...">
												{
													ch = tag.getParam(HtmlTag.P_SRC );
													typeDeTag = "T_IMG";
												}
											if ( tagType == HtmlTag.T_BODY )		//Tag <BODY BACKGROUND="...">
												{
													ch = tag.getParam(HtmlTag.P_BACKGROUND  );
													typeDeTag = "T_BODY BACKGROUND";
												}
												if ( tagType == HtmlTag.T_LINK )		//Tag <LINK HREF="..."> pour les stylesheet...
												{
													ch = tag.getParam(HtmlTag.P_HREF  );
													typeDeTag = "T_BODY BACKGROUND";
												}

											if ( ch != null )
												{
													links.addElement(ch);
												}
										}
									catch (HtmlException ex)
										{
											System.out.println("<" + tok.getStringValue() + ">");
										}
								}
						}
				}
			catch (IOException ex)
				{
				}
			
			// Inserer tous les liens trouves dans lst.
			// Completer les liens incomplet en fonction du contexte.
			lst = new ListeEntiteURL(); // Reinitialiser la liste des nouveaux liens !
			int i, n;
			URL url = null;  // Important d'initialiser pour effet de bord.
			EntiteURL e;
			String chUrl = "";
			
			n = links.size();
			for ( i = 0 ; i < n ; i++ )
				{
					
					
					ch = (String) links.elementAt(i);
					// On tente l'URL complet.
					try
						{
							url = new URL(ch);
							// Si pas d'exception alors l'URL est complet, il ne faut pas le completer.
						}
					catch (java.net.MalformedURLException ex)
						{
							//System.out.println("Pb lors de la creation de l'URL 1 : "+ch);
						}
					
					if ( url == null )
						{
							// Sinon on tente en completant avec le BASE HREF :
							if ( base != null && base.compareTo("") != 0 ) ch = base + ch;
							
							// On tente a nouveau, si besoin de la completion, elle se fera :
							try
								{
									url = new URL(entiteURL.getURL(),ch);
									//continue;  // Passer au suivant								}
								}
							catch (java.net.MalformedURLException ex)
								{
									//System.out.println("Pb lors de la creation de l'URL 2 : "+ch);
								}
						}
					
					// Virer les protocole autre que http et ftp :
					if ( url != null && url.getProtocol().compareTo("http") != 0 &&  url.getProtocol().compareTo("ftp") != 0 )
						url = null;
					
					// Validation de l'URL cree.
					if ( url != null )
						{
							e = new EntiteURL(url,entiteURL.getProfondeur()-1);
							if ( sortirDomaine )
								{
									lst.addElement(e);
								}
							else
								{
									if ( e.getURL().getHost().compareTo(listeEntiteURL.getURL().getHost()) == 0 )
										lst.addElement(e);
								}
							url = null;
						}
				} // For
			
			// Reste  inserer dans la liste principale si besoin.
			lst.addThisTo(listeEntiteURL,entiteURL);
			entiteURL.setParsed(true);
			
			return(true);
		}	
}



