// **********************
// *** ListeEntiteURL ***
// **********************

import java.net.URL;
import java.util.Vector;
import java.io.*;

/**
 * Classe decrivant une liste d'EntiteURL, sans doublon sur l'attribut URL des EntiteURLs.
 *
 * @author Bruno GERY
 * @version Version 1.00
 */
public class ListeEntiteURL implements Serializable
{
	private Vector v = null;
	
	ListeEntiteURL()
		{
			v = new Vector();
		}
	
	/**
	 * Ajouter un element a la liste en s'assurant qu'il n'y a pas de doublon sur l'attribut URL.
	 * @return l'element qui a ete ajoute ou celui dont il faut mettre la profondeur a jour.
	 */
	public final synchronized EntiteURL addElement(EntiteURL u)
		{
			int i, n;
			EntiteURL e;
			
			n = v.size();
			// On verifie qu'il n'y a aucun element ayant le meme URL.
			for ( i = 0 ; i < n ; i++ )
				{
					e = (EntiteURL) v.elementAt(i);
					if ( e.getURL().sameFile(u.getURL()) )  return(e);  // Il FAUT faire ici la remise a niveau de la pronfondeur.
				}
			// On peut alors l'ajouter puisqu'il n'y ait pas !
			v.addElement(u);
			
			return(u);  // On retourne l'element ajoute.
		} // addElement()
	
	/**
	 * Ajoute tous les element de la liste dans la liste passee en argument.
	 * Il n'y a pas de synchronisation car cette methode ne doit pas etre utiliseren mode ajout pendant l'operation
	 *
	 */
	public void addThisTo(ListeEntiteURL lst, EntiteURL entiteURL)
		{
			int i, n;
			EntiteURL e, r;
			int profondeur = entiteURL.getProfondeur();
			
			if ( lst == this ) return;  // Operation interdite !
			
			n = v.size();
			for ( i = 0 ; i < n ; i++ )
				{
				e = (EntiteURL) v.elementAt(i);
				r = lst.addElement(e);
				entiteURL.addChild(r);
				// Il existe et a peut etre deja ete parse
				if ( r != e )
					if ( r.setProfondeur(profondeur) )
						{
						(new Thread(new ProfondeurChecker(r)) ).start();
						}
				}
		}
	
	/**
	 * Retourne une EntiteURL a telecharger.<BR>
	 * L'entiteURL retournee est mise a l'etat <I>telecharging</I> !
	 * Il faudra donc la liberer apres terlechargement en appellant l'une des methodes :
	 * <I>setTelecharged(true)</I> ou <I>setTelecharging(false)</I>
	 *
	 * @return Une EntiteURL a telecharger et <B>null</B> s'il n'y en a pas.
	 */
	public final EntiteURL getElementToTelecharge()
		{
			int i, n;
			EntiteURL e;
			
			// Le vecteur ne peut que grossir :
			// Il n'est donc pas neccasire de synchroniser la methode ou de faire une copie du vecteur.
			n = v.size();
			// On cherhe un element telecharge.
			for ( i = 0 ; i < n ; i++ )
				{
					e = (EntiteURL) v.elementAt(i);
					if ( e.isToTelecharge() )  return(e);
				}
			
			return(null);
		}
	
	/**
	 * Retourne une EntiteURL a parser.<BR>
	 * L'entiteURL retournee est mise a l'etat <I>parsing</I> !
	 * Il faudra donc la liberer apres le parsing en appellant l'une des methodes :
	 * <I>setTelecharged(true)</I> ou <I>setTelecharging(false)</I>
	 *
	 * @return Une EntiteURL a parser et <B>null</B> s'il n'y en a pas.
	 */
	public final EntiteURL getElementToParse()
		{
			int i, n;
			EntiteURL e;
			
			// Le vecteur ne peut que grossir :
			// Il n'est donc pas neccasire de synchroniser la methode ou de faire une copie du vecteur.
			n = v.size();
			// On cherhe un element telecharge.
			for ( i = 0 ; i < n ; i++ )
				{
					e = (EntiteURL) v.elementAt(i);
					if ( e.isToParse() )  return(e);
				}
			
			return(null);
		}
	
	/**
	 * Indique s'il reste ne reste aucune EntiteURL a Paarse ou a Telecharger.
	 *
	 * @return true s'il n'y a rien a faire (Telecharger ou parser), false sinon.
	 */
	public final boolean nothingToDo()
		{
			int i, n;
			EntiteURL e;
			
			// Le vecteur ne peut que grossir :
			// Il n'est donc pas neccasire de synchroniser la methode ou de faire une copie du vecteur.
			n = v.size();
			// On cherhe un element telecharge.
			for ( i = 0 ; i < n ; i++ )
				{
					e = (EntiteURL) v.elementAt(i);
					if ( e.isToParse() )
						{
							e.setParsing(false);  // Pour liberer l'EntiteURL bloquee par isToParse();
							return(false);
						}
					if ( e.isToTelecharge() )
						{
							e.setTelecharging(false);  // Pour liberer l'EntiteURL bloquee par isToParse();
							return(false);
						}
				}
			if ( n != v.size() ) return(false);  // Si le vecteur a grossi pendant le test !
			
			return(true);  // Plus rien a faire dans cette liste.
		}
	
	public URL getURL()
		{
			EntiteURL e;
			
			if ( v.size() > 0 )
				{
					e = (EntiteURL) v.elementAt(0);
					return(e.getURL());
				}
			
			return(null);
		}
	
	public EntiteURL getFirst()
		{
			EntiteURL e = null;
			
			if ( v.size() > 0 )
				{
					e = (EntiteURL) v.elementAt(0);
				}
			
			return(e);
		}
	
	public String toString()
		{
			int i, n;
			String r = "";
			
			n = v.size();
			r = "ListeEntiteUTL :\n";
			for ( i = 0 ; i < n ; i++ )
				r = r + "\t" + (EntiteURL) v.elementAt(i)+"\n";
			
			return(r);
		}
	
} // ListeEntiteURL



