// ****************
// *** JGrabWeb ***
// ****************

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.undo.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.LineBorder;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;

/**
 * Interface graphique de : J-GrabWeb
 *
 * @author  Bruno GERY
 * @version 1.0
 */
class JGrabWeb extends JPanel implements ActionListener
{
	
	private static ImageIcon iconCheckBoxNormal, iconCheckBoxSelected;
  private static ImageIcon iconBoutLancerPressed, iconBoutLancerNormal, iconBoutLancerDisabled;
	private static ImageIcon iconLabelURL;
  private static ImageIcon iconBoutQuitterNormal, iconBoutQuitterPressed, iconBoutQuitterDisabled;

	private JCheckBox checkBoxSortirSite;
	private JButton boutLancer, boutQuitter, boutCharger;
	private JTextField textFieldURL;
	private JComboBox comboNbThread, comboProfondeur;
	private JLabel labelPath, labelLogo;
  private static  ImageIcon iconLogo;
	
	private static JFrame frame;
	

	static
		{
			try
				{
					String nomFichier;
					
					// Icone logo :
					nomFichier = "images/logo.gif";
					iconLogo = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					// Images du bouton Lancer :
					nomFichier = "images/iconBoutLancerNormal.gif";
					iconBoutLancerNormal = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutLancerPressed.gif";
					iconBoutLancerPressed = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));

					nomFichier = "images/iconBoutLancerDisabled.gif";
					iconBoutLancerDisabled = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					// Image du LabelURL :
					nomFichier = "images/iconLabelURL.gif";
					iconLabelURL = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
          
					// Image du CheckBox sortir du domaine :
					nomFichier = "images/iconCheckBoxNormal.gif";
					iconCheckBoxNormal = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconCheckBoxSelected.gif";
					iconCheckBoxSelected = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					// Bouton Quitter :
					nomFichier = "images/iconBoutQuitterNormal.gif";
					iconBoutQuitterNormal = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutQuitterPressed.gif";
					iconBoutQuitterPressed = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));

					nomFichier = "images/iconBoutQuitterDisabled.gif";
					iconBoutQuitterDisabled = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));

				} 
			catch (Exception ex)
				{
					System.err.println("Certains fichiers ressources sont manquant");
					System.exit(1);
				}
		}
	
	public void actionPerformed(ActionEvent evt)
		{
			Object obj;
			JButton bout;
			
			obj = evt.getSource();
			if ( obj instanceof JButton )
				{
					bout = (JButton) obj;
					if ( bout == boutLancer )
							nouveauTelechargement();
					if ( bout == boutCharger )
							chargerListe();
					if ( bout == boutQuitter )
							System.exit(0); // FIN du programme !
				}
			
		}
	
	private void nouveauTelechargement()
		{
			Integer integer;
			int nbThread, profondeur;
			boolean sortirDuDomaine;
			URL url;
			ListeEntiteURL lst = new ListeEntiteURL();
			EntiteURL entite;
			PiocheurDeTelechargement piocheur;

			try
				{
					sortirDuDomaine	= checkBoxSortirSite.isSelected();
					
					integer = new Integer((String) comboProfondeur.getSelectedItem());
					profondeur = integer.intValue();
					
					integer = new Integer((String) comboNbThread.getSelectedItem());
					nbThread = integer.intValue();
					
					url = new URL(textFieldURL.getText());
					entite = new EntiteURL(url,profondeur);
					lst.addElement(entite);
					
					// On lance le piocheur de telechargement :
					piocheur = new PiocheurDeTelechargement(lst,nbThread,sortirDuDomaine,"telechargement/");
					piocheur.start();
				}
			catch (Exception ex)
				{
					// Afficher un dialog Swing (facile avec mess erreur) !!!
					System.out.println("Exception newTelechargemement : "+ex);
				}
			
		}
	
	JGrabWeb()
		{
			super(true);
			
			try
				{
					// On met le look multiplateforme par defaut :
					UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
					// Pour changer le look,echanger le commentaire qui suit avec la ligne precedente.
					// UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
				}
			catch (Exception exc)
				{
					System.err.println("Erreur au chargement de L&F: " + exc);
				}
			
			setBorder(BorderFactory.createEtchedBorder());
			setLayout(new BorderLayout());
			
			add("Center", creerPanneauCentral());
			//JPanel p = new JPanel();
			//add("South", new JLabel("Aide contextuelle"));
    }
	
	public JPanel creerPanneauCentral()
		{
			JPanel panel, bigPanel;
			JPanel p;
			int i;
			
			panel = new JPanel();
			panel.setLayout(new GridLayout(6,1));
			
			bigPanel = new JPanel(new BorderLayout());
			
			labelLogo = new JLabel(iconLogo);

			textFieldURL = new JTextField("http://www.essi.fr/",50);
			
			// iconCheckBoxNormal, iconCheckBoxSelected, iconBoutLancerSelected, iconBoutLancerNormal, iconLabelURL;
			
			// Creation de la case a cocher :
			checkBoxSortirSite = new JCheckBox("Continuer en dehors du nom de domaine");
			//checkBoxSortirSite = new JCheckBox("Continuer en dehors du nom de domaine",iconCheckBoxNormal);
			checkBoxSortirSite.setSelectedIcon(iconCheckBoxSelected); // Image a mettre qd selectionne.
			
			// Creation du combo :
			comboProfondeur = new JComboBox();
			comboProfondeur.setEditable(true);
			// Remplir le combo :
			for ( i = 1 ; i <= 15 ; i++ )
				{
					comboProfondeur.addItem(new String(""+i));
				}
			comboProfondeur.setSelectedIndex(2);
				
			// Creation du combo :
			comboNbThread =  new JComboBox();
			comboNbThread.setEditable(true);
			// Remplir le combo :
			for ( i = 1 ; i <= 30 ; i++ )
				{
					comboNbThread.addItem(new String(""+i));
				}
			comboNbThread.setSelectedIndex(9);
			
			labelPath = new JLabel("telechargement/");
			labelPath.setForeground(Color.red);
			
			boutLancer = new JButton("Lancer",iconBoutLancerNormal);
			boutLancer.setPressedIcon(iconBoutLancerPressed);
			boutLancer.setHorizontalTextPosition(boutLancer.CENTER);
			boutLancer.setVerticalTextPosition(boutLancer.BOTTOM);
			//boutLancer.setSelectedIcon(iconBoutLancerSelected);
			//boutLancer.setDisabledIcon(iconBoutLancerSelected);
			//boutLancer.setDisabledSelectedIcon();
			//boutLancer.setRolloverIcon(Icon);
			//boutLancer.setRolloverSelectedIcon(Icon);
			
			boutQuitter = new JButton("Quitter",iconBoutQuitterNormal);
			boutQuitter.setPressedIcon(iconBoutQuitterPressed);
			boutQuitter.setBackground(Color.lightGray);
			boutQuitter.setHorizontalTextPosition(boutQuitter.CENTER);
			boutQuitter.setVerticalTextPosition(boutQuitter.BOTTOM);
			//boutQuitter.setOpaque(true);
			
			boutCharger = new JButton("Reprendre");
			
			boutCharger.addActionListener(this);
			boutLancer.addActionListener(this);
			boutQuitter.addActionListener(this);
			
			// Mise en place des composants dans le panneau :
			
			JPanel p1 = new JPanel(new BorderLayout());
			p1.add("West",new JLabel("URL : ",iconLabelURL,SwingConstants.RIGHT));
			p1.add("East",textFieldURL);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(p1);
			panel.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(checkBoxSortirSite);
			panel.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(comboProfondeur);
			p.add(new JLabel("Profondeur de la recusion sur les liens"));
			panel.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(comboNbThread);
			p.add(new JLabel("Nombre de telechargement en parallele"));
			panel.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(new JLabel("Sauver dans : "));
			p.add(labelPath);
			panel.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(boutCharger);
			p.add(new JLabel(" un telechargement interrompu et sauve sur disque"));
			panel.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.CENTER));
			p.add(boutLancer);
			p.add(boutQuitter);
			bigPanel.add("South",p);
			
			panel.setBorder(new LineBorder(Color.darkGray, 2));
			bigPanel.add("Center",panel);
			
			bigPanel.add("North", labelLogo);

			return(bigPanel);
		}
	
	public static void main(String[] args)
		{
			JGrabWeb p;
			
			try
				{
					String vers = System.getProperty("java.version");
					if (vers.compareTo("1.1.2") < 0)
						{
							System.out.println("ATTENTION: Swing doit etre lance avec une version de la VM > 1.1.2");
						}
					
					frame = new JFrame();
					frame.setTitle("J-GrabWeb");
					frame.setBackground(Color.lightGray);
					frame.getContentPane().setLayout(new BorderLayout());
					p =  new JGrabWeb();
					frame.getContentPane().add("Center",p);
					//frame.addWindowListener(new AppCloser()); // ???
					frame.pack();
					
					//frame.setSize(500, 600);
					Dimension taille = p.getPreferredSize();
					taille.width += 5;
					taille.height += 5;
					frame.setSize(taille);
					frame.show();
        }
			catch (Throwable t)
				{
					System.out.println("Exception non recuperee: " + t);
					t.printStackTrace();
        }
    }
		
		public boolean 	chargerListe()
		{
				ObjectInputStream fluxIn = null;
				String nomFichier = "liste.obj";
				ListeEntiteURL lst;
				
				
				FileDialog selecteur = new FileDialog(frame, "Ouvrir telechargement",FileDialog.LOAD);
				selecteur.show();
				// Vrification de selection :
				nomFichier = selecteur.getFile();
				if ( nomFichier == null )  return(false);
				// Vrification de l'existance de la selection :
				File selection = new File(selecteur.getDirectory()+selecteur.getFile());
				if ( !selection.isFile() )  return(false);
				
				File file = selection;
				
				try
						{
								fluxIn = new ObjectInputStream(new FileInputStream(file));
								if ( fluxIn == null )
										{
												System.out.println("Pas pu creer le fichier : "+file.getAbsolutePath());
												return(false);
										}
								lst = (ListeEntiteURL) fluxIn.readObject();
								fluxIn.close();
						}
				catch ( Exception ex)
						{
								System.out.println("Pas pu creer le fichier : "+file.getAbsolutePath());
								return(false);
						}
				
				//A refaire en plus propre, juste pour la demo.
				boolean sortirDuDomaine	= false;
				int nbThread = 10;
				
				// On lance le piocheur de telechargement :
				PiocheurDeTelechargement piocheur = new PiocheurDeTelechargement(lst,nbThread,sortirDuDomaine,"telechargement/");
				piocheur.start();
				
				return(true);
		}

}
