
// *******************************
// *** FenetreDeTelechargement ***
// *******************************

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.net.URL;
import java.util.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.undo.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.LineBorder;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;



/**
 * Interface graphique de : J-GrabWeb
 * Le fenetre de telechargement.
 *
 * @author  Bruno GERY
 * @version 1.0
 */
public class FenetreDeTelechargement extends JPanel implements ActionListener
{
	private static ImageIcon iconBoutStopNormal, iconBoutStopPressed, iconBoutStopDisabled;
  private static ImageIcon iconBoutSauverNormal, iconBoutSauverPressed, iconBoutSauverDisabled;
  private static ImageIcon iconBoutChargerNormal, iconBoutChargerPressed, iconBoutChargerDisabled;

	
	public JButton boutStop, boutSauver, boutReprendre, boutFermer;
	public JLabel labelErreur, labelEffectue, labelVolume, labelEtat;
	private List listThread;
	private DefaultListModel model;
	public JFrame frame;
	private JPanel panel;
	private ListeEntiteURL lst;
	private TreePanel treePanel;
	
	private String nomFenetre = "Telechargement de ";
	
	static
		{
			try
				{
					String nomFichier;
					
					// Bouton Stop  du Telechargement :
					nomFichier = "images/iconBoutStopNormal.gif";
					iconBoutStopNormal = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutStopPressed.gif";
					iconBoutStopPressed = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutStopDisabled.gif";
					iconBoutStopDisabled = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					// Bouton Sauver du telechargement
					nomFichier = "images/iconBoutSauverNormal.gif";
					iconBoutSauverNormal = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutSauverPressed.gif";
					iconBoutSauverPressed = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutSauverDisabled.gif";
					iconBoutSauverDisabled = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					// Bouton Charger du telechargement
					nomFichier = "images/iconBoutChargerNormal.gif";
					iconBoutChargerNormal = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutChargerPressed.gif";
					iconBoutChargerPressed = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
					nomFichier = "images/iconBoutChargerDisabled.gif";
					iconBoutChargerDisabled = new ImageIcon(new URL("file:///"+System.getProperty("user.dir")+ "/"+nomFichier));
					
				} 
			catch (Exception ex)
				{
					System.err.println("Certains fichiers ressources sont manquant");
					System.exit(1);
				}
		}
	
	public JPanel creerPanneau()
		{
			JPanel p, west;
			
			panel = new JPanel(new BorderLayout());
			
			boutStop = new JButton(iconBoutStopNormal);
			boutStop.setPressedIcon(iconBoutStopPressed);
			boutStop.setDisabledIcon(iconBoutStopDisabled);
			boutStop.setBorderPainted(false);
			boutStop.addActionListener(this);
			
			boutSauver = new  JButton("Sauver",iconBoutSauverNormal);
			boutSauver.setPressedIcon(iconBoutSauverPressed);
			boutSauver.setDisabledIcon(iconBoutSauverDisabled);
			boutSauver.addActionListener(this);
			boutSauver.setEnabled(false);
			
			boutReprendre = new  JButton("Relancer", iconBoutChargerNormal);
			boutReprendre.setPressedIcon(iconBoutChargerPressed);
			boutReprendre.setDisabledIcon(iconBoutChargerDisabled);
			boutReprendre.setEnabled(false);

			boutFermer = new  JButton("Fermer");
			boutFermer.setEnabled(false);
			
			labelErreur = new JLabel("000000");
			labelEffectue = new JLabel("000000");
			labelVolume = new JLabel("000 000 000 octets");
			labelEtat = new JLabel("Telechargement en cours ...");
			labelEtat.setBackground(Color.red);
			labelEtat.setForeground(Color.black);
			
			model = new DefaultListModel();
			
			// Creer la liste bidon pour calcul de la taille.
			for(int i = 0; i <= 15 ; i++)
				{
					//model.addElement(new JLabel("Item bidon"+i));
					model.addElement("Item bidon"+i);
				}
			listThread = new List(10);
			//listThread.setCellRenderer(new BasicListCellRenderer());
			
			// Mise en place des composants dans le panneau :
			west = new JPanel(new BorderLayout());

			p = new JPanel(new FlowLayout(FlowLayout.CENTER));

			p.add(boutFermer);
		  west.add("South", p);
			
			// Le panneau des informations sur le telechargement
			JPanel p1 = new JPanel(new GridLayout(4, 0));
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(new JLabel("Erreurs : "));
			p.add(labelErreur);
			p1.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(new JLabel("Effectues : "));
			p.add(labelEffectue);
			p1.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(new JLabel("Volume : "));
			p.add(labelVolume);
			p1.add(p);

			p.add(new JLabel(""));
			p1.add(p);


			// Les icones qui permettent de piloter le telechargement
			JPanel p2 = new JPanel(new GridLayout(5, 0));
			p = new JPanel(new FlowLayout(FlowLayout.CENTER));
			p.add(boutSauver);
			p2.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.CENTER));
			p.add(boutReprendre);
			p2.add(p);
			
			p = new JPanel(new FlowLayout(FlowLayout.CENTER));
			p.add(boutStop);
			p2.add(p);

			// Un peu d'espace pour aerer tout ca...
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(new JLabel(""));
			p2.add(p);
		
			p = new JPanel(new FlowLayout(FlowLayout.LEFT));
			p.add(new JLabel(""));
			p2.add(p);
		

			p = new JPanel(new BorderLayout());

			p.add("South", p1);     // Les informations
			p.add("Center", p2);    // les icones
			west.add(p);

			panel.add("West",west);
			panel.add("Center",listThread);
			panel.add("South",labelEtat);
			return(panel);
		}
	
	public FenetreDeTelechargement(ListeEntiteURL lst, String nomFenetre)
		{
			super(true);
			
			this.lst = lst;
			this.nomFenetre = this.nomFenetre + nomFenetre;
			
			setBorder(BorderFactory.createEtchedBorder());
			setLayout(new BorderLayout());
			
			add("Center", creerPanneau());
		}
	
	public void ouvrirFenetre()
		{
			frame = new JFrame(nomFenetre);
			frame.setTitle("Telechargement");
			frame.setBackground(Color.lightGray);
			frame.getContentPane().setLayout(new BorderLayout());
			frame.getContentPane().add("Center",this);
			//frame.addWindowListener(new AppCloser()); // ???
			frame.pack();
			
			//frame.setSize(500, 600);
			Dimension taille = this.getPreferredSize();
			taille.width += 5+200;
			taille.height += 5;
			frame.setSize(taille);
			frame.show();
		}
	
	public void actionPerformed(ActionEvent evt)
		{
			Object obj;
			JButton bout;
			
			obj = evt.getSource();
			if ( obj instanceof JButton )
				{
					bout = (JButton) obj;
					
					if ( bout == boutStop )
						{
							//model.addElement("Element ajoute par Stop");
							//listThread.validate();
							//model.addElement(new JLabel("Element ajoute"));
						}
					
				}
			
		}
	
	public void addList(String url)
		{
			listThread.add(url);
			//model.addElement(url);
			//listThread.validate();
		}
	
	public void removeList(String url)
		{
			listThread.remove(url);
			//model.removeElement(url);
			//listThread.validate();
		}
	
	public void reprendre()
		{
			boutStop.setEnabled(true);
			boutReprendre.setEnabled(false);
			boutSauver.setEnabled(false);
			boutFermer.setEnabled(false);
			labelEtat.setText("Telechargement en cours");
			labelEtat.setForeground(Color.red);
			panel.remove(treePanel);
			panel.add("Center",listThread);
			panel.validate();
		}
	
	public void closeFenetre()
		{
			frame.hide();
		}
	
	public void showTree()
		{
			EntiteURL e;
			
			boutStop.setEnabled(false);
			boutReprendre.setEnabled(true);
			boutSauver.setEnabled(true);
			boutFermer.setEnabled(true);
			labelEtat.setText("Telechargement termine");
			labelEtat.setForeground(Color.red);
			
			e = lst.getFirst();
			if ( e != null )
				{
					panel.remove(listThread);
					treePanel = new TreePanel(e);
					panel.add("Center",treePanel);
					panel.validate();
				}
		}
	
	public void setStat(int nbOK, int nbKO, long vol)
		{
			labelErreur.setText(""+nbKO);
			labelEffectue.setText(""+nbOK);
			labelVolume.setText(""+vol);
		}
	
} // FenetreDeTelechargement
