// *****************
// *** EntiteURL ***
// *****************

import java.io.*;
import java.util.*;
import java.net.*;

/**
 * Classe decrivant une <B>EntiteURL</B> :<BR>
 * On entend par la une URL a telecharger et tout les attributs neccessaire a cette tache.<BR>
 * <UL>
 * <LI>La profondeur ou il faut encore redescendre recursivement (si l'URL est un fichier HTML).
 * <LI>L'endroit ou ce fichier est stocke en local apres son telechargement.
 * <LI>Si le fichier est encore a telecharger, en cours de telechargement.
 * <LI>Si le fichier est telecharge, et s'il a deja ete parse (si HTML).
 * <LI>Le type du fichier : HTML, GIF, JPG, ...
 * <LI>Enfin la liste de tous les URLs contenus dans ce fichier (HTML).
 * </UL>
 *
 * @author Bruno GERY
 * @version Version 1.00
 */
public class EntiteURL implements Serializable
{
	// Attributs :
	private static int nbMaxErreur = 2;
	private int nbErreur = 0;  // Compte le nb d'erreur de telechargement et abandonne qd > nbMaxErreur !
	private URL url = null;  // L'URL du fichier a telecharger.
	private int profondeur;  // Le nombre de recursion a effectuer sur les fils.
	                 // Si 0, c'est un URL final => Pas de parsing, on s'arrete.
	
	private File fichier = null;  // Le fichier dans lequel celui de l'URL est sauvegarde.
	private boolean telecharging = false;  // En cours de telechargement ds une Thread.
	private boolean telecharged = false;  // Telecharge et sauve sur disque.
	private boolean parsing = false;  // Parsing en cours (seulement pour HTML et qd teleCharged).
	private boolean parsed = false;  // Parsing effectue (seulement pour HTML et qd teleCharged).
	
	private String mimeType = null;  // Type du fichier : text/html , image/gif , image/jpeg , text/plain , application/java-vm , ...
	
	private Vector childs = null;  // Liste des ArbreURL reference dans celui-ci : genere par la parsing !
	
	public String toString()
		{
			return("URL("+url+")\t parsed = "+parsed+"\t parsing = "+parsing);
		}
	
	// Methodes :
	
	public EntiteURL(URL url, int profondeur)
		{
			this.url = url;
			this.profondeur = profondeur;  // Doit etre >= 0.
			childs = new Vector();
		} // ArbreURL()
	
	/**
	 * Retourne la valeur du MimeType de l'EntiteURL a condition que l'URL ait deja ete telecharge.
	 *
	 * @return Le MimeType de l'URL telecharge ou null si le telechargement n'a pas encore ete effectue;
	 * @see EntiteURL#setMimeType
	 */
	public synchronized String getMimeType() { return(mimeType); }
	
	/**
	 * Positionne la valeur du MimeType
	 *
	 * @see EntiteURL#getMimeType
	 */
	public synchronized void setMimeType(String mimeType)
		{
			this.mimeType = mimeType;
		}
	
	public synchronized File getFile() { return(fichier); }
	
	/**
	 * Positionne la valeur du fichier ou le fichier correcpondant a l'URL est stocke sur le disque.
	 *
	 * @see EntiteURL#getFile
	 */
	public synchronized void setFile(File file)
		{
			fichier = file;
		}
	
	public URL getURL() { return(url); }
	
	/**
	 * @return Retourne la profondeur a laquelle il faut descendre recursivement sur cet URL.
	 */
	public synchronized int getProfondeur()
		{
			return(profondeur);
		}
	
	/**
	 * Positionne la profondeur a laquelle il faut descendre recursivement sur cet URL.
	 * @return true si la profondeur des fils doit etre mise a niveau, false sinon.
	 */
	public synchronized boolean setProfondeur(int profondeur)
		{
			if ( profondeur > this.profondeur )
				{
					this.profondeur = profondeur;
					if ( parsed )  return(true);  // Les fils ne sont pas cree, pas la peine de mettre a niveau.
				}
			
			return(false);  // Pas de modif necessaire.
		}
	
	/**
	 * @return Retourne la profondeur a laquelle il faut descendre recursivement sur cet URL.
	 */
	public synchronized void setTelecharging(boolean telecharging)
		{
			this.telecharging = telecharging;
		}
	
	public synchronized boolean getEnTelecharging()
		{
			return(telecharging);
		}
	
	/**
	 * Determine si l'EntiteURL est a telecharge.
	 * Si tel est le cas l'objet bascule dans l'etat telechargement en cours.
	 * L'objet considere alors que l'appelant de la methode va effectuer le telechargement 
	 * et appeller ensuite la methode setTelecharged() pour signifier que le telechargement est termine.
	 * L'appellant <B>doit</B> appeller la methode <I>setTelecharged(true)</I> ou <I>setTelecharging(false)</I>
	 *
	 * @return true si l'EntiteURL est a telecharger, false sinon.
	 */
	public synchronized boolean isToTelecharge()
		{
			if ( telecharging == false && telecharged == false && nbErreur <= nbMaxErreur )
				{
					telecharging = true;  // Telechargement de l'URL en cours.
					return(true);
				}
			
			return(false);
		}
	
	public synchronized void setTelecharged(boolean telecharged)
		{
			this.telecharged = telecharged;
		}
	
	public synchronized boolean getTelecharged()
		{
			return(telecharged);
		}
	
	public synchronized boolean isToParse()
		{
			
      if ( mimeType == null )  return(false);
			if ( profondeur > 0 && telecharged == true &&  (mimeType.compareTo("text/html") == 0) && parsed == false && parsing == false && nbErreur <= nbMaxErreur )
				{
					parsing = true;  // Parsing du fichier en cours.
					return(true);
				}
					
			return(false);
		}
	
	public synchronized void setParsing(boolean parsing)
		{
			this.parsing = parsing;
		}
	
	public synchronized void setParsed(boolean parsed)
		{
			this.parsed = parsed;
		}
	
	public synchronized boolean getParsed()
		{
			return(parsed);
		}
	
	/**
	 *Incremente le nombre d'erreur au telechargement et libere telecharging.
	 * @return true si des tentatives sont encore possible et false sinon.
	 */
	
	public boolean incErreur()
		{
			nbErreur++;
			if ( nbErreur > nbMaxErreur )  return(false);
			telecharging = false;
			return(true);
		}
	
	// --- Traitement de l'arbe des fils ---
	
	/**
	 * Ajoute un fils a cet EntiteURL.
	 * On verifie qu'il n'y ait pas de doublons.
	 */
	public void addChild(EntiteURL e)
		{
			if ( !childs.contains(e) )
				childs.addElement(e);
		}
	
	public int childSize()
		{
			return(childs.size());
		}
	
	public EntiteURL childAt(int i)
		{
			return( (EntiteURL) childs.elementAt(i) );
		}
	
} // EntiteURL



