import java.util.Vector;
import java.awt.Component;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTable;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.table.AbstractTableModel;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableCellRenderer;

class JPTable extends AbstractTableModel implements TableCellRenderer
{
    static final JLabel caseVide= new JLabel();
    String[] names;  // nom des colonnes
    Vector elements; // elements de la table, ce sont des DefaultMutableTreeNode contenant un DirElement ou derive
    JTable table;    // representation de la table

    public JPTable(String[] names)
    {
	this.names= names;
	elements= new Vector();
	table= new JTable(this);
	table.setShowHorizontalLines(false);
	table.setShowVerticalLines(false);
	for (int i= 0; i<names.length; ++i)
	    table.getColumn(names[i]).setCellRenderer(this);
    }

    public JTable getJTable()
    {
	return table;
    }

    public int getColumnCount()
    {
	return names.length;
    }

    public int getRowCount()
    {
	return elements.size();
    }

    public Object getValueAt(int row, int col)
    {
	return ((DirElement)((DefaultMutableTreeNode)elements.elementAt(row)).getUserObject()).getValueAt(col);
    }

    public String getColumnName(int col)
    {
	return names[col];
    }

    public void add(DefaultMutableTreeNode element)
    {
	int i= elements.size();

	elements.addElement(element);
	table.tableChanged(new TableModelEvent(this,i,i,TableModelEvent.ALL_COLUMNS,TableModelEvent.INSERT));
    }

    public void erase()
    {
	elements.removeAllElements();
	table.tableChanged(new TableModelEvent(this));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column)
    {
	return (value==null)?caseVide:(Component)value;
    }
  }
