import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.awt.Component;
import com.sun.java.swing.JLabel;

class DataElement extends DirElement
{
    public static final String[] names= {"Name","Type","Date","Length"}; // please put this array in the last subclass of DirElement; see getValueAt

    public DataElement(String name, Object relatedObject, URL url)
    {
	super(name,relatedObject,new Component[4]);
	if (url!=null)
	    {
		try
		    {
			URLConnection uc= url.openConnection();

			components[1]= new JLabel(uc.getContentType(),JLabel.CENTER);
			components[2]= new JLabel(new Date(uc.getDate()).toLocaleString());
			components[3]= new JLabel(Integer.toString(uc.getContentLength()),JLabel.RIGHT);
		    }
		catch(java.io.IOException x) {}
	    }
    }
}
