/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.Action;
import com.sun.java.swing.JEditorPane;
import com.sun.java.swing.event.CaretEvent;
import com.sun.java.swing.event.CaretListener;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BoxView;
import com.sun.java.swing.text.ComponentView;
import com.sun.java.swing.text.DefaultEditorKit;
import com.sun.java.swing.text.DefaultStyledDocument;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.EditorKit;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.IconView;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.LabelView;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.ParagraphView;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.text.TextAction;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.Serializable;

public class StyledEditorKit
extends DefaultEditorKit {
    private static final ViewFactory defaultFactory = new StyledViewFactory();
    Element currentRun;
    Element currentParagraph;
    MutableAttributeSet inputAttributes = new 1();
    private AttributeTracker caretHandler = new AttributeTracker();
    private static final Action[] defaultActions = new Action[]{new FontFamilyAction("font-family-Helvetica", "Helvetica"), new FontFamilyAction("font-family-Courier", "Courier"), new FontFamilyAction("font-family-TimesRoman", "TimesRoman"), new FontSizeAction("font-size-8", 8), new FontSizeAction("font-size-10", 10), new FontSizeAction("font-size-12", 12), new FontSizeAction("font-size-14", 14), new FontSizeAction("font-size-16", 16), new FontSizeAction("font-size-18", 18), new FontSizeAction("font-size-24", 24), new FontSizeAction("font-size-36", 36), new FontSizeAction("font-size-48", 48), new AlignmentAction("left-justify", 0), new AlignmentAction("center-justify", 1), new AlignmentAction("right-justify", 2), new BoldAction(), new ItalicAction(), new UnderlineAction()};

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public Element getCharacterAttributeRun() {
        return this.currentRun;
    }

    public Object clone() {
        return new StyledEditorKit();
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public Document createDefaultDocument() {
        return new DefaultStyledDocument();
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addCaretListener(this.caretHandler);
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeCaretListener(this.caretHandler);
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    private final class 1
    extends SimpleAttributeSet {
        public AttributeSet getResolveParent() {
            if (StyledEditorKit.this.currentParagraph != null) {
                return StyledEditorKit.this.currentParagraph.getAttributes();
            }
            return null;
        }

        /* synthetic */ 1() {
        }
    }

    class AttributeTracker
    implements CaretListener,
    Serializable {
        public void caretUpdate(CaretEvent caretEvent) {
            int n;
            int n2 = caretEvent.getDot();
            if (n2 == (n = caretEvent.getMark())) {
                JTextComponent jTextComponent = (JTextComponent)caretEvent.getSource();
                StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
                Element element = styledDocument.getCharacterElement(Math.max(n2 - 1, 0));
                StyledEditorKit.this.currentParagraph = styledDocument.getParagraphElement(n2);
                if (element != StyledEditorKit.this.currentRun) {
                    StyledEditorKit.this.currentRun = element;
                    StyledEditorKit.this.inputAttributes.removeAttributes(StyledEditorKit.this.inputAttributes);
                    StyledEditorKit.this.inputAttributes.addAttributes(StyledEditorKit.this.currentRun.getAttributes());
                    StyledEditorKit.this.inputAttributes.removeAttribute(StyleConstants.ComponentAttribute);
                    StyledEditorKit.this.inputAttributes.removeAttribute(StyleConstants.IconAttribute);
                    StyledEditorKit.this.inputAttributes.removeAttribute("$ename");
                }
            }
        }

        AttributeTracker() {
            StyledEditorKit.this = StyledEditorKit.this;
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new LabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }

        StyledViewFactory() {
        }
    }

    public static abstract class StyledTextAction
    extends TextAction {
        public StyledTextAction(String string) {
            super(string);
        }

        protected final JEditorPane getEditor(ActionEvent actionEvent) {
            if (actionEvent != null) {
                Object object = actionEvent.getSource();
                if (object instanceof JEditorPane) {
                    return (JEditorPane)object;
                }
                JTextComponent jTextComponent = this.getFocusedComponent();
                if (jTextComponent instanceof JEditorPane) {
                    return (JEditorPane)jTextComponent;
                }
            }
            throw new IllegalArgumentException("target must be JEditorPane");
        }

        protected final StyledDocument getStyledDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof StyledDocument) {
                return (StyledDocument)document;
            }
            throw new IllegalArgumentException("document must be StyledDocument");
        }

        protected final StyledEditorKit getStyledEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof StyledEditorKit) {
                return (StyledEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit must be StyledEditorKit");
        }

        protected final void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
            int n;
            int n2 = jEditorPane.getSelectionStart();
            if (n2 != (n = jEditorPane.getSelectionEnd())) {
                StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
                styledDocument.setCharacterAttributes(n2, n - n2, attributeSet, bl);
                return;
            }
            StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
            MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
            if (bl) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }

        protected final void setParagraphAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
            int n = jEditorPane.getSelectionStart();
            int n2 = jEditorPane.getSelectionEnd();
            StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
            styledDocument.setParagraphAttributes(n, n2 - n, attributeSet, bl);
        }
    }

    public static class FontFamilyAction
    extends StyledTextAction {
        private String family;

        public FontFamilyAction(String string, String string2) {
            super(string);
            this.family = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                Object object2 = this.family;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane && (object = actionEvent.getActionCommand()) != null) {
                    object2 = object;
                    System.out.println("s: " + (String)object);
                }
                if (object2 != null) {
                    object = new SimpleAttributeSet();
                    StyleConstants.setFontFamily((MutableAttributeSet)object, (String)object2);
                    this.setCharacterAttributes(jEditorPane, (AttributeSet)object, false);
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public static class FontSizeAction
    extends StyledTextAction {
        private int size;

        public FontSizeAction(String string, int n) {
            super(string);
            this.size = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                int n = this.size;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane) {
                    object = actionEvent.getActionCommand();
                    try {
                        n = Integer.parseInt((String)object, 10);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (n != 0) {
                    object = new SimpleAttributeSet();
                    StyleConstants.setFontSize((MutableAttributeSet)object, n);
                    this.setCharacterAttributes(jEditorPane, (AttributeSet)object, false);
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public static class ForegroundAction
    extends StyledTextAction {
        private Color fg;

        public ForegroundAction(String string, Color color) {
            super(string);
            this.fg = color;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                Color color = this.fg;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane) {
                    object = actionEvent.getActionCommand();
                    try {
                        color = Color.decode((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (color != null) {
                    object = new SimpleAttributeSet();
                    StyleConstants.setForeground((MutableAttributeSet)object, color);
                    this.setCharacterAttributes(jEditorPane, (AttributeSet)object, false);
                    return;
                }
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public static class AlignmentAction
    extends StyledTextAction {
        private int a;

        public AlignmentAction(String string, int n) {
            super(string);
            this.a = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                int n = this.a;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane) {
                    object = actionEvent.getActionCommand();
                    try {
                        n = Integer.parseInt((String)object, 10);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                object = new SimpleAttributeSet();
                StyleConstants.setAlignment((MutableAttributeSet)object, n);
                this.setParagraphAttributes(jEditorPane, (AttributeSet)object, false);
            }
        }
    }

    public static class BoldAction
    extends StyledTextAction {
        public BoldAction() {
            super("font-bold");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                boolean bl = !StyleConstants.isBold(mutableAttributeSet);
                StyleConstants.setBold(mutableAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, mutableAttributeSet, false);
            }
        }
    }

    public static class ItalicAction
    extends StyledTextAction {
        public ItalicAction() {
            super("font-italic");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                boolean bl = !StyleConstants.isItalic(mutableAttributeSet);
                StyleConstants.setItalic(mutableAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, mutableAttributeSet, false);
            }
        }
    }

    public static class UnderlineAction
    extends StyledTextAction {
        public UnderlineAction() {
            super("font-underline");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                boolean bl = !StyleConstants.isUnderline(mutableAttributeSet);
                StyleConstants.setUnderline(mutableAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, mutableAttributeSet, false);
            }
        }
    }
}

