/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.plaf.DirectoryPaneUI;
import com.sun.java.swing.preview.DirectoryModel;
import com.sun.java.swing.preview.FileType;
import com.sun.java.swing.preview.TypedFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class JDirectoryPane
extends JComponent
implements SwingConstants,
Accessible {
    protected DirectoryModel directoryModel;
    protected ListSelectionModel listSelectionModel;
    protected transient Redirector redirector;
    protected transient SelListener selListener;
    protected String command;
    protected String doubleClickCommand = "doubleClick";
    protected String doubleClickContainerCommand = "doubleClickContainer";
    GoUpAction goUpAction = new GoUpAction();
    DefaultActionListener defaultActionListener = new DefaultActionListener();
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JDirectoryPane() {
        this((File)null);
    }

    public JDirectoryPane(String string) {
        this(string == null ? null : new File(string));
    }

    public JDirectoryPane(File file) {
        this.setModel(this.createDirectoryModel(file));
        this.setSelectionModel(this.createSelectionModel());
        this.addActionListener(this.getDefaultActionListener());
        this.updateUI();
    }

    protected DirectoryModel createDirectoryModel(File file) {
        return new DirectoryModel(file);
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public Action getGoUpAction() {
        return this.goUpAction;
    }

    public ActionListener getDefaultActionListener() {
        return this.defaultActionListener;
    }

    public void performDoubleClick() {
        TypedFile typedFile = this.getSelectedFile();
        if (typedFile.getType().isContainer()) {
            this.fireActionPerformed(this.getDoubleClickContainerCommand());
            return;
        }
        this.fireActionPerformed(this.getDoubleClickCommand());
    }

    public TypedFile getSelectedFile() {
        int n = this.getListSelectionModel().getLeadSelectionIndex();
        if (n >= 0) {
            return (TypedFile)this.getModel().getTypedFiles().elementAt(n);
        }
        return null;
    }

    public Vector getSelectedFiles() {
        ListSelectionModel listSelectionModel = this.getListSelectionModel();
        int n = listSelectionModel.getAnchorSelectionIndex();
        int n2 = listSelectionModel.getLeadSelectionIndex();
        Vector vector = new Vector();
        if (n >= 0 && n2 >= 0) {
            Vector vector2 = this.getModel().getTypedFiles();
            int n3 = Math.max(n, n2);
            int n4 = Math.min(n, n2);
            while (n4 <= n3) {
                vector.addElement(vector2.elementAt(n4));
                ++n4;
            }
        }
        return vector;
    }

    public boolean isSelectionEmpty() {
        return this.getListSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getListSelectionModel().clearSelection();
    }

    public File getCurrentDirectory() {
        return this.directoryModel.getCurrentDirectory();
    }

    public void setCurrentDirectory(File file) {
        this.directoryModel.setCurrentDirectory(file);
    }

    public TypedFile getTypedFile(String string, String string2) {
        return this.directoryModel.getTypedFile(string, string2);
    }

    public TypedFile getTypedFile(String string) {
        return this.directoryModel.getTypedFile(string);
    }

    public Vector getTypedFiles() {
        return this.directoryModel.getTypedFiles();
    }

    public Vector getTypedFilesForDirectory(File file) {
        return this.directoryModel.getTypedFilesForDirectory(file);
    }

    public boolean canGoUp() {
        return this.directoryModel.canGoUp();
    }

    public void goUp() {
        this.directoryModel.goUp();
    }

    public void setHiddenRule(FileType fileType) {
        this.directoryModel.setHiddenRule(fileType);
    }

    public FileType getHiddenRule() {
        return this.directoryModel.getHiddenRule();
    }

    public void addKnownFileType(FileType fileType) {
        this.directoryModel.addKnownFileType(fileType);
    }

    public Enumeration enumerateKnownFileTypes() {
        return this.directoryModel.enumerateKnownFileTypes();
    }

    public Vector getKnownFileTypes() {
        return this.directoryModel.getKnownFileTypes();
    }

    public boolean isKnownFileType(FileType fileType) {
        return this.directoryModel.isKnownFileType(fileType);
    }

    public void setKnownFileTypes(FileType[] fileTypeArray) {
        this.directoryModel.setKnownFileTypes(fileTypeArray);
    }

    public DirectoryPaneUI getUI() {
        return (DirectoryPaneUI)this.ui;
    }

    public void setUI(DirectoryPaneUI directoryPaneUI) {
        super.setUI(directoryPaneUI);
    }

    public void updateUI() {
        this.setUI((DirectoryPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "DirectoryPaneUI";
    }

    public DirectoryModel getModel() {
        return this.directoryModel;
    }

    protected void setModel(DirectoryModel directoryModel) {
        DirectoryModel directoryModel2 = this.getModel();
        if (directoryModel2 != null) {
            directoryModel2.removePropertyChangeListener(this.redirector);
            this.redirector = null;
        }
        this.directoryModel = directoryModel;
        if (directoryModel != null) {
            this.redirector = this.createRedirector();
            directoryModel.addPropertyChangeListener(this.redirector);
        }
    }

    public ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    protected void setSelectionModel(ListSelectionModel listSelectionModel) {
        ListSelectionModel listSelectionModel2 = this.getListSelectionModel();
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this.selListener);
            this.selListener = null;
        }
        this.listSelectionModel = listSelectionModel;
        if (listSelectionModel != null) {
            this.selListener = this.createSelectionListener();
            listSelectionModel.addListSelectionListener(this.selListener);
        }
    }

    protected Redirector createRedirector() {
        return new Redirector();
    }

    protected SelListener createSelectionListener() {
        return new SelListener();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JDirectoryPane.class$("java.awt.event.ActionListener")), actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JDirectoryPane.class$("java.awt.event.ActionListener")), actionListener);
    }

    protected void fireActionPerformed(String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JDirectoryPane.class$("java.awt.event.ActionListener"))) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, string);
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public void setActionCommand(String string) {
        String string2 = this.command;
        this.command = string;
        this.firePropertyChange("actionCommand", string2, string);
    }

    public String getActionCommand() {
        return this.command;
    }

    public void setDoubleClickCommand(String string) {
        String string2 = this.doubleClickCommand;
        this.doubleClickCommand = string;
        this.firePropertyChange("doubleClickCommand", string2, string);
    }

    public String getDoubleClickCommand() {
        return this.doubleClickCommand;
    }

    public void setDoubleClickContainerCommand(String string) {
        String string2 = this.doubleClickContainerCommand;
        this.doubleClickContainerCommand = string;
        this.firePropertyChange("doubleClickContainerCommand", string2, string);
    }

    public String getDoubleClickContainerCommand() {
        return this.doubleClickContainerCommand;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDirectoryPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class Redirector
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "currentDirectory") {
                JDirectoryPane.this.getListSelectionModel().clearSelection();
            }
        }

        Redirector() {
            JDirectoryPane.this = JDirectoryPane.this;
        }
    }

    protected class SelListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JDirectoryPane.this.fireActionPerformed(JDirectoryPane.this.command);
            }
        }

        SelListener() {
            JDirectoryPane.this = JDirectoryPane.this;
        }
    }

    protected class GoUpAction
    extends AbstractAction {
        protected GoUpAction() {
            super("Go Up");
            JDirectoryPane.this = JDirectoryPane.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDirectoryPane.this.goUp();
        }
    }

    protected class DefaultActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(JDirectoryPane.this.getDoubleClickContainerCommand())) {
                JDirectoryPane.this.setCurrentDirectory(JDirectoryPane.this.getSelectedFile());
            }
        }

        DefaultActionListener() {
            JDirectoryPane.this = JDirectoryPane.this;
        }
    }

    protected class AccessibleJDirectoryPane
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIRECTORY_PANE;
        }

        AccessibleJDirectoryPane() {
            JDirectoryPane.this = JDirectoryPane.this;
        }
    }
}

