/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview;

import com.sun.java.swing.Icon;
import java.io.File;

public interface FileType {
    public static final GenericFile SharedGenericFile = new GenericFile();
    public static final Folder SharedFolder = new Folder();
    public static final Hidden SharedHidden = new Hidden();
    public static final Computer SharedComputer = new Computer();
    public static final FloppyDrive SharedFloppyDrive = new FloppyDrive();
    public static final HardDrive SharedHardDrive = new HardDrive();

    public String getPresentationName();

    public boolean testFile(File var1);

    public Icon getIcon();

    public boolean isContainer();

    public static class GenericFile
    implements FileType {
        protected GenericFile() {
        }

        public String getPresentationName() {
            return "File";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            return true;
        }

        public boolean isContainer() {
            return false;
        }
    }

    public static class Folder
    implements FileType {
        protected Folder() {
        }

        public String getPresentationName() {
            return "Folder";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            return file.isDirectory();
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class Hidden
    implements FileType {
        protected Hidden() {
        }

        public String getPresentationName() {
            return "Hidden";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            String string = file.getName();
            return string.length() > 0 && string.charAt(0) == '.';
        }

        public boolean isContainer() {
            return false;
        }
    }

    public static class Computer
    implements FileType {
        protected Computer() {
        }

        public String getPresentationName() {
            return "Computer";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            return false;
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class FloppyDrive
    implements FileType {
        protected FloppyDrive() {
        }

        public String getPresentationName() {
            return "3" + '\u00bd' + " Inch Floppy Disk";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            String string = file.getPath();
            if (string.length() == 3 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                char c = string.charAt(0);
                return c == 'A' || c == 'a' || c == 'B' || c == 'b';
            }
            return false;
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class HardDrive
    implements FileType {
        protected HardDrive() {
        }

        public String getPresentationName() {
            return "Disk Drive";
        }

        public Icon getIcon() {
            return null;
        }

        public boolean testFile(File file) {
            String string = file.getPath();
            if (string.length() == 3 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                char c = string.charAt(0);
                return c >= 'C' && c <= 'Z' || c >= 'c' && c <= 'z';
            }
            return false;
        }

        public boolean isContainer() {
            return true;
        }
    }

    public static class ExtensionBased
    implements FileType {
        private String[] extensions;
        private String presentationName;
        private Icon icon;

        public ExtensionBased(String string, String string2, Icon icon) {
            this.presentationName = string;
            this.extensions = new String[1];
            this.extensions[0] = string2;
            this.icon = icon;
        }

        public ExtensionBased(String string, String[] stringArray, Icon icon) {
            if (stringArray.length < 1) {
                throw new IllegalArgumentException("Empty extensions array");
            }
            this.presentationName = string;
            this.extensions = (String[])stringArray.clone();
            this.icon = icon;
        }

        public boolean testFile(File file) {
            int n = this.extensions.length;
            String string = file.getPath();
            int n2 = 0;
            while (n2 < n) {
                String string2 = this.extensions[n2];
                if (string.endsWith(string2) && string.charAt(string.length() - string2.length()) == '.') {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getPresentationName() {
            if (this.presentationName == null) {
                return this.extensions[0];
            }
            return this.presentationName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public boolean isContainer() {
            return false;
        }
    }
}

