/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class WindowsBorderFactory {
    private static Border buttonBorder;
    private static Border toggleButtonBorder;
    private static Border radioButtonBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new WindowsButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new WindowsToggleBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getRadioButtonBorder() {
        if (radioButtonBorder == null) {
            radioButtonBorder = new WindowsRadioBorder();
        }
        return radioButtonBorder;
    }

    private static class WindowsToggleBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(graphics, n, n2, n3, n4);
                    return;
                }
                BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, abstractButton.isFocusPainted() && abstractButton.hasFocus());
                return;
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        WindowsToggleBorder() {
        }
    }

    private static class WindowsButtonBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                bl = buttonModel.isPressed() && buttonModel.isArmed();
                bl2 = abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton();
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, bl, bl2);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        WindowsButtonBorder() {
        }
    }

    private static class WindowsRadioBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(graphics, n, n2, n3, n4);
                    return;
                }
                BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, abstractButton.isFocusPainted() && abstractButton.hasFocus());
                return;
            }
            BasicGraphicsUtils.drawBezel(graphics, n, n2, n3, n4, false, false);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        WindowsRadioBorder() {
        }
    }
}

