/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicMenuUI;
import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class MotifMenuUI
extends BasicMenuUI {
    protected ChangeListener changeListener;
    protected static final int defaultTextIconGap = 2;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifMenuUI();
    }

    protected void initListeners(JComponent jComponent) {
        super.initListeners(jComponent);
        this.changeListener = this.createChangeListener(jComponent);
    }

    protected void addListeners(JComponent jComponent) {
        super.addListeners(jComponent);
        ((JMenuItem)jComponent).addChangeListener(this.changeListener);
    }

    protected void removeListeners(JComponent jComponent) {
        super.removeListeners(jComponent);
        ((JMenuItem)jComponent).removeChangeListener(this.changeListener);
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new MenuChangeListener();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.installDefaultIcons();
        MotifGraphicsUtils.paintMenuItem(graphics, jComponent, this.checkIcon, this.menuArrow, BasicMenuUI.pressedBackground, BasicMenuUI.pressedForeground, 2);
    }

    boolean popupIsOpen(JMenu jMenu, MenuElement[] menuElementArray) {
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        int n = menuElementArray.length - 1;
        while (n >= 0) {
            if (menuElementArray[n].getComponent() == jPopupMenu) {
                return true;
            }
            --n;
        }
        return false;
    }

    public void processMouseEvent(JMenuItem jMenuItem, MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        Component component;
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getID() == 503 || mouseEvent.getID() == 504 || mouseEvent.getID() == 505) {
            return;
        }
        if (!jMenuItem.isEnabled()) {
            return;
        }
        if (point.x >= 0 && point.x < jMenuItem.getWidth() && point.y >= 0 && point.y < jMenuItem.getHeight()) {
            JMenu jMenu = (JMenu)jMenuItem;
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            if (!this.popupIsOpen(jMenu, menuElementArray2) || mouseEvent.getID() == 502) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    MenuElement[] menuElementArray3;
                    if (mouseEvent.getID() == 502) {
                        menuElementArray3 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = jMenu.getPopupMenu();
                        MenuElement[] menuElementArray4 = jMenu.getPopupMenu().getSubElements();
                        if (menuElementArray4.length > 0) {
                            menuElementArray3[menuElementArray.length + 1] = menuElementArray4[0];
                        } else {
                            MenuElement[] menuElementArray5 = new MenuElement[menuElementArray.length + 1];
                            System.arraycopy(menuElementArray3, 0, menuElementArray5, 0, menuElementArray3.length - 1);
                            menuElementArray3 = menuElementArray5;
                        }
                    } else {
                        menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = jMenu.getPopupMenu();
                    }
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                    return;
                }
                menuSelectionManager.setSelectedPath(menuElementArray);
                this.setupPostTimer(jMenu);
            }
            return;
        }
        if (mouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(mouseEvent.getComponent(), mouseEvent.getPoint())) == null) {
            menuSelectionManager.clearSelectedPath();
        }
    }

    protected class MenuChangeListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
            if (jMenuItem.isArmed() || jMenuItem.isSelected()) {
                jMenuItem.setBorderPainted(true);
                return;
            }
            jMenuItem.setBorderPainted(false);
        }

        MenuChangeListener() {
            MotifMenuUI.this = MotifMenuUI.this;
        }
    }
}

