/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.CellRendererPane;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.plaf.BorderUIResource;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicComboBoxUI;
import com.sun.java.swing.plaf.metal.MetalComboBoxButton;
import com.sun.java.swing.plaf.metal.MetalComboBoxIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    protected MetalComboBoxButton button;
    protected MetalComboBoxButton arrowCache;
    private static Border emptyBorder = new BorderUIResource(new EmptyBorder(0, 0, 0, 0));

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.removeArrowButton();
        this.addArrowButton();
        if (this.editor != null) {
            Font font = jComponent.getFont();
            this.editor.setFont(new Font(font.getName(), font.getStyle(), font.getSize()));
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.button != null) {
            this.comboBox.remove(this.button);
            this.button = null;
        }
        JComboBox jComboBox = this.comboBox;
        super.uninstallUI(jComponent);
        jComboBox.removeAll();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), true);
        if (this.comboBox.isEditable()) {
            this.arrowCache = metalComboBoxButton;
        }
        return metalComboBoxButton;
    }

    public void layoutContainer(Container container) {
        if (this.comboBox.isEditable()) {
            super.layoutContainer(container);
            return;
        }
        if (this.button != null) {
            this.button.setSize(this.comboBox.getSize().width, this.comboBox.getSize().height);
        }
    }

    public void editablePropertyChanged() {
        if (this.comboBox.isEditable()) {
            if (this.button != null) {
                this.comboBox.remove(this.button);
                this.button = null;
            }
            super.editablePropertyChanged();
            if (this.arrowCache != null) {
                this.comboBox.add(this.arrowCache);
                this.comboBox.repaint();
            } else if (this.arrowButton == null) {
                this.addArrowButton();
            }
            this.arrowCache = (MetalComboBoxButton)this.arrowButton;
            this.comboBox.setBorder(emptyBorder);
            return;
        }
        this.removeEditor();
        if (this.arrowButton != null) {
            this.comboBox.remove(this.arrowButton);
            this.arrowCache = (MetalComboBoxButton)this.arrowButton;
            this.arrowButton = null;
        }
        if (this.button == null) {
            this.comboBox.getInsets();
            this.button = new MetalComboBoxButton(this.comboBox, (Icon)new MetalComboBoxIcon());
            this.button.setLocation(0, 0);
            this.button.setSize(this.comboBox.getSize().width - 2, this.comboBox.getSize().height);
        }
        this.comboBox.add(this.button);
    }

    protected void setupListBox(JList jList, JComboBox jComboBox) {
        ((Component)jList).setFont(jComboBox.getFont());
        jList.setForeground(UIManager.getColor("ComboBox.listForeground"));
        jList.setBackground(UIManager.getColor("ComboBox.listBackground"));
        jList.setSelectionForeground(UIManager.getColor("ComboBox.selectedForeground"));
        jList.setSelectionBackground(UIManager.getColor("ComboBox.selectedBackground"));
    }

    public void hidePopup() {
        super.hidePopup();
        if (this.arrowCache != null) {
            this.arrowCache.getModel().setPressed(false);
            this.arrowCache.repaint();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        if (this.button != null) {
            this.button.forceDrawFocus(true);
            this.button.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (this.button != null) {
            this.button.forceDrawFocus(false);
            this.button.repaint();
        }
    }

    public CellRendererPane getCurrentValuePane() {
        return this.currentValuePane;
    }

    public void addArrowButton() {
        this.arrowButton = this.createArrowButton();
        this.arrowButton.setRequestFocusEnabled(true);
        this.comboBox.add(this.arrowButton);
        this.comboBox.repaint();
    }

    public void removeArrowButton() {
        if (this.arrowButton != null) {
            this.comboBox.remove(this.arrowButton);
            this.arrowButton = null;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.getSource() == this.listBox && this.button != null) {
            this.button.getModel().setPressed(false);
            return;
        }
        if (mouseEvent.getSource() == this.listBox && this.arrowButton != null) {
            this.arrowButton.getModel().setPressed(false);
        }
    }

    public void doMouseDragged(MouseEvent mouseEvent) {
        if (this.popupIsVisible()) {
            MouseEvent mouseEvent2 = this.convertEventToListBox(mouseEvent);
            this.updateListBoxSelectionForEvent(mouseEvent2, true);
            this.lastMouseLocation = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), null);
            Window window = SwingUtilities.windowForComponent((Component)mouseEvent.getSource());
            this.lastMouseLocation.x += window.getBounds().x;
            this.lastMouseLocation.y += window.getBounds().y;
            this.startAutoscrolling();
        }
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = super.getMaximumSize(jComponent);
        dimension.height += 4;
        return dimension;
    }

    public void doMouseReleased(MouseEvent mouseEvent) {
        this.stopAutoscrolling();
        if (this.popupIsVisible()) {
            MouseEvent mouseEvent2 = this.convertEventToListBox(mouseEvent);
            this.updateListBoxSelectionForEvent(mouseEvent2, true);
            Object object = this.listBox.getSelectedValue();
            if (object != null) {
                this.comboBox.getModel().setSelectedItem(object);
            }
            this.hidePopup();
        }
    }

    public void enablePropertyChanged() {
        if (this.button != null) {
            this.button.setEnabled(this.comboBox.isEnabled());
        }
        if (this.arrowCache != null) {
            this.arrowCache.setEnabled(this.comboBox.isEnabled());
        }
        super.enablePropertyChanged();
    }

    protected void addKeyAccelerators(JComponent jComponent) {
        JComboBox jComboBox = this.comboBox;
        MetalComboBoxUI metalComboBoxUI = this;
        super.addKeyAccelerators(jComponent);
        this.comboBox.registerKeyboardAction(new 1(jComboBox, metalComboBoxUI), KeyStroke.getKeyStroke(32, 0), 0);
    }

    protected void removeKeyAccelerators(JComponent jComponent) {
        super.removeKeyAccelerators(jComponent);
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
    }

    private static final class 1
    extends AbstractAction {
        private final /* synthetic */ JComboBox val$myComboBox;
        private final /* synthetic */ MetalComboBoxUI val$myUI;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.val$myUI.popupIsVisible()) {
                this.val$myUI.hidePopup();
                return;
            }
            this.val$myUI.showPopup();
        }

        public boolean isEnabled() {
            return this.val$myComboBox.isEnabled();
        }

        /* synthetic */ 1(JComboBox jComboBox, MetalComboBoxUI metalComboBoxUI) {
            this.val$myComboBox = jComboBox;
            this.val$myUI = metalComboBoxUI;
        }
    }
}

