/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicButtonListener;
import com.sun.java.swing.plaf.basic.BasicButtonUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.metal.MetalButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class MetalButtonUI
extends BasicButtonUI {
    private static final MetalButtonUI metalButtonUI = new MetalButtonUI();

    protected Color getSelectColor() {
        return UIManager.getColor("Button.pressed");
    }

    protected Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledText");
    }

    protected Color getFocusColor() {
        return UIManager.getColor("Button.focus");
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return metalButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(true);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isOpaque()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    protected void paintFocus(Graphics graphics, Dimension dimension) {
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
            return;
        }
        graphics.setColor(UIManager.getColor("Button.disabledText"));
        BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected BasicButtonListener createListener(JComponent jComponent) {
        return new MetalButtonListener((AbstractButton)jComponent);
    }
}

