/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.SyntheticImage;
import com.sun.java.swing.plaf.basic.ColorPatch;
import com.sun.java.swing.plaf.basic.ImageComponent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

class HueLightnessPatch
extends ImageComponent
implements AdjustmentListener {
    int sx;
    int sy;
    private static int cursorWidth = 3;
    SyntheticImage hli;
    ColorPatch target;
    Adjustable hue;
    Adjustable saturation;
    Adjustable brightness;
    int color;

    HueLightnessPatch(ColorPatch colorPatch, Adjustable adjustable, Adjustable adjustable2, Adjustable adjustable3) {
        this.target = colorPatch;
        this.hue = adjustable;
        this.saturation = adjustable2;
        this.brightness = adjustable3;
        colorPatch.setColor(0xFF0000);
        this.enableEvents(48L);
    }

    protected void locateImage() {
        if (this.img == null) {
            Dimension dimension = this.getSize();
            int n = this.color;
            Adjustable adjustable = this.hue;
            this.hli = new 1(n, adjustable, dimension);
            this.setImage(this.getToolkit().createImage(this.hli));
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: 
            case 506: {
                int n = this.isize.height;
                int n2 = this.isize.width;
                this.brightness.setValue((n - mouseEvent.getY() - 1) * 100 / (n - 1));
                this.saturation.setValue((n2 - mouseEvent.getX() - 1) * 100 / (n2 - 1));
            }
        }
    }

    public void setColor(int n) {
        this.color = n;
        if (this.hli != null) {
            this.hli.nextFrame(n);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.processMouseEvent(mouseEvent);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.isize.height - 1;
        int n2 = this.isize.width - 1;
        int n3 = n2 - this.saturation.getValue() * n2 / 100;
        int n4 = n - this.brightness.getValue() * n / 100;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paintCursor(graphics, this.sx, this.sy);
            this.paintCursor(graphics, n3, n4);
            graphics.dispose();
        }
        this.sx = n3;
        this.sy = n4;
        this.propogateColor();
    }

    void propogateColor() {
        this.target.setColor(Color.HSBtoRGB((float)this.hue.getValue() / 360.0f, (float)this.saturation.getValue() / 100.0f, (float)this.brightness.getValue() / 100.0f));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintCursor(graphics, this.sx, this.sy);
    }

    private void paintCursor(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        graphics.setXORMode(Color.black);
        graphics.drawLine(n - 3, n2, n + 3, n2);
        graphics.drawLine(n, n2 - 3, n, n2 + 3);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private final class 1
    extends SyntheticImage {
        int color;
        int nextColor;
        Adjustable hue;
        boolean changed;

        public synchronized void nextFrame(int n) {
            if (this.color != (n |= 0xFF000000)) {
                this.changed = true;
                this.notifyAll();
            }
            this.nextColor = n;
        }

        private synchronized void waitNextColor() {
            try {
                while (!this.changed) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.changed = false;
            this.color = this.nextColor;
        }

        protected boolean isStatic() {
            return false;
        }

        protected void computeRow(int n, int[] nArray) {
            int n2;
            if (n == 0) {
                this.waitNextColor();
            }
            float f = (float)this.hue.getValue() / 360.0f;
            float f2 = (float)(this.height - n - 1) / (float)(this.height - 1);
            int n3 = n2 = this.width;
            while (--n3 >= 0) {
                float f3 = (float)(n2 - n3 - 1) / (float)(n2 - 1);
                nArray[n3] = Color.HSBtoRGB(f, f3, f2);
            }
        }

        /* synthetic */ 1(int n, Adjustable adjustable, Dimension dimension) {
            this.hue = adjustable;
            this.width = dimension.width;
            this.height = dimension.height;
            this.nextFrame(n);
        }
    }
}

