/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.ProgressBarUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class BasicProgressBarUI
extends ProgressBarUI
implements ChangeListener,
Serializable {
    int cachedPercent;
    static final Dimension PREFERRED_INNER_HORIZONTAL = new Dimension(146, 12);
    static final Dimension PREFERRED_INNER_VERTICAL = new Dimension(12, 146);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installListeners(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        jComponent.setOpaque(true);
        LookAndFeel.installColorsAndFont(jComponent, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
    }

    protected void installListeners(JComponent jComponent) {
        ((JProgressBar)jComponent).addChangeListener(this);
    }

    protected void uninstallListeners(JComponent jComponent) {
        ((JProgressBar)jComponent).removeChangeListener(this);
    }

    protected void uninstallDefaults(JComponent jComponent) {
    }

    public Dimension getPreferredInnerHorizontal() {
        return PREFERRED_INNER_HORIZONTAL;
    }

    public Dimension getPreferredInnerVertical() {
        return PREFERRED_INNER_VERTICAL;
    }

    public int getCachedPercent() {
        return this.cachedPercent;
    }

    public void setCachedPercent(int n) {
        this.cachedPercent = n;
    }

    public int getBorderBuffer() {
        return 0;
    }

    public int getCellLength() {
        return 1;
    }

    public int getCellSpacing() {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        BoundedRangeModel boundedRangeModel = jProgressBar.getModel();
        Insets insets = this.getBorderInsets(jComponent);
        int n = insets.left;
        int n2 = insets.top;
        Dimension dimension2 = new Dimension(dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        graphics.setColor(jComponent.getForeground());
        if (jProgressBar.getOrientation() == 0) {
            long l = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n3 = 0;
            if (l != 0L) {
                double d = dimension2.width;
                double d2 = boundedRangeModel.getValue();
                double d3 = d2 / (double)l;
                n3 = (int)(d * d3);
            }
            int n4 = n + n3 - this.getCellLength();
            int n5 = this.getCellLength() + this.getCellSpacing();
            int n6 = n;
            while (n6 < n4) {
                graphics.fillRect(n6, n2, this.getCellLength(), dimension2.height);
                n6 += n5;
            }
            if (n3 == dimension2.width && n6 < dimension2.width + n) {
                graphics.fillRect(n6, n2, dimension2.width + n - n6, dimension2.height);
            }
        } else {
            int n7 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n8 = 0;
            if (n7 != 0) {
                double d = dimension2.height;
                double d4 = boundedRangeModel.getValue();
                double d5 = d4 / (double)n7;
                n8 = (int)(d * d5);
            }
            int n9 = dimension2.height - 1 + n2 - n8;
            int n10 = this.getCellLength() + this.getCellSpacing();
            int n11 = dimension2.height - 1 + (n2 - this.getCellLength());
            while (n11 > n9) {
                graphics.fillRect(n, n11, dimension2.width, this.getCellLength());
                n11 -= n10;
            }
            if (n8 == dimension2.height) {
                graphics.fillRect(n, n2, dimension2.width, n11 + this.getCellLength() - n2);
            }
        }
        if (jProgressBar.isBorderPainted()) {
            BasicGraphicsUtils.drawEtchedRect(graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        Insets insets = this.getBorderInsets(jComponent);
        Dimension dimension = jProgressBar.getOrientation() == 0 ? new Dimension(this.getPreferredInnerHorizontal()) : new Dimension(this.getPreferredInnerVertical());
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        if (jProgressBar.getOrientation() == 0) {
            dimension.width = 0;
        } else {
            dimension.height = 0;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        if (jProgressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    public Insets getInsets(JComponent jComponent) {
        return this.getBorderInsets(jComponent);
    }

    public Insets getBorderInsets(JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        if (jProgressBar.isBorderPainted()) {
            Insets insets = (Insets)BasicGraphicsUtils.getEtchedInsets().clone();
            insets.left += this.getBorderBuffer();
            insets.right += this.getBorderBuffer();
            insets.top += this.getBorderBuffer();
            insets.bottom += this.getBorderBuffer();
            return insets;
        }
        return new Insets(0, 0, 0, 0);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        JProgressBar jProgressBar = (JProgressBar)changeEvent.getSource();
        BoundedRangeModel boundedRangeModel = jProgressBar.getModel();
        int n2 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
        int n3 = n = n2 > 0 ? 100 * boundedRangeModel.getValue() / n2 : 0;
        if (n != this.getCachedPercent()) {
            int n4 = Math.min(n, this.getCachedPercent());
            int n5 = Math.max(n, this.getCachedPercent());
            Insets insets = this.getBorderInsets(jProgressBar);
            Dimension dimension = jProgressBar.getSize();
            if (jProgressBar.getOrientation() == 0) {
                int n6 = dimension.width - (insets.right + insets.left);
                int n7 = n4 * n6 / 100;
                int n8 = n5 * n6 / 100;
                int n9 = this.getCellLength() + this.getCellSpacing();
                n7 = n7 / n9 * n9 + insets.left;
                n8 = (n8 / n9 + 1) * n9 + insets.left;
                jProgressBar.repaint();
            } else {
                int n10 = dimension.height - (insets.bottom + insets.top);
                int n11 = n5 * n10 / 100;
                int n12 = n4 * n10 / 100;
                int n13 = this.getCellLength() + this.getCellSpacing();
                n11 = n10 - (n11 / n13 + 1) * n13 + insets.top;
                n12 = n10 - n12 / n13 * n13 + insets.top;
                jProgressBar.repaint(insets.left, n11 - 1, dimension.width - (insets.left + insets.right), n12 - n11 + 2);
            }
            this.setCachedPercent(n);
        }
    }
}

