/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.JScrollBar;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JViewport;
import com.sun.java.swing.ScrollPaneConstants;
import com.sun.java.swing.Scrollable;
import com.sun.java.swing.border.Border;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy = 20;
    protected int hsbPolicy = 30;

    protected Component addSingletonComponent(Component component, Component component2) {
        if (component != null && component != component2) {
            component.getParent().remove(component);
        }
        return component2;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("VIEWPORT")) {
            this.viewport = (JViewport)this.addSingletonComponent(this.viewport, component);
            return;
        }
        if (string.equals("VERTICAL_SCROLLBAR")) {
            this.vsb = (JScrollBar)this.addSingletonComponent(this.vsb, component);
            return;
        }
        if (string.equals("HORIZONTAL_SCROLLBAR")) {
            this.hsb = (JScrollBar)this.addSingletonComponent(this.hsb, component);
            return;
        }
        if (string.equals("ROW_HEADER")) {
            this.rowHead = (JViewport)this.addSingletonComponent(this.rowHead, component);
            return;
        }
        if (string.equals("COLUMN_HEADER")) {
            this.colHead = (JViewport)this.addSingletonComponent(this.colHead, component);
            return;
        }
        if (string.equals("LOWER_LEFT_CORNER")) {
            this.lowerLeft = this.addSingletonComponent(this.lowerLeft, component);
            return;
        }
        if (string.equals("LOWER_RIGHT_CORNER")) {
            this.lowerRight = this.addSingletonComponent(this.lowerRight, component);
            return;
        }
        if (string.equals("UPPER_LEFT_CORNER")) {
            this.upperLeft = this.addSingletonComponent(this.upperLeft, component);
            return;
        }
        if (string.equals("UPPER_RIGHT_CORNER")) {
            this.upperRight = this.addSingletonComponent(this.upperRight, component);
            return;
        }
        throw new IllegalArgumentException("invalid layout key " + string);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
            return;
        }
        if (component == this.vsb) {
            this.vsb = null;
            return;
        }
        if (component == this.hsb) {
            this.hsb = null;
            return;
        }
        if (component == this.rowHead) {
            this.rowHead = null;
            return;
        }
        if (component == this.colHead) {
            this.colHead = null;
            return;
        }
        if (component == this.lowerLeft) {
            this.lowerLeft = null;
            return;
        }
        if (component == this.upperLeft) {
            this.upperLeft = null;
            return;
        }
        if (component == this.upperRight) {
            this.upperRight = null;
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public void setVerticalScrollBarPolicy(int n) {
        switch (n) {
            case 20: 
            case 21: 
            case 22: {
                this.vsbPolicy = n;
                return;
            }
        }
        throw new IllegalArgumentException("invalid verticalScrollBarPolicy");
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public void setHorizontalScrollBarPolicy(int n) {
        switch (n) {
            case 30: 
            case 31: 
            case 32: {
                this.hsbPolicy = n;
                return;
            }
        }
        throw new IllegalArgumentException("invalid horizontalScrollBarPolicy");
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public Component getCorner(String string) {
        if (string.equals("LOWER_LEFT_CORNER")) {
            return this.lowerLeft;
        }
        if (string.equals("LOWER_RIGHT_CORNER")) {
            return this.lowerRight;
        }
        if (string.equals("UPPER_LEFT_CORNER")) {
            return this.upperLeft;
        }
        if (string.equals("UPPER_RIGHT_CORNER")) {
            return this.upperRight;
        }
        return null;
    }

    public Dimension preferredLayoutSize(Container container) {
        Border border;
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
        }
        if (dimension != null) {
            n += dimension.width;
            n2 += dimension.height;
        }
        if ((border = ((JScrollPane)container).getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n += insets2.left + insets2.right;
            n2 += insets2.top + insets2.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n2 += this.colHead.getPreferredSize().height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                n += this.vsb.getPreferredSize().width;
            } else if (dimension2 != null && dimension != null) {
                boolean bl = true;
                if (component instanceof Scrollable) {
                    boolean bl2 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportHeight();
                }
                if (bl && dimension2.height > dimension.height) {
                    n += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                n2 += this.hsb.getPreferredSize().height;
            } else if (dimension2 != null && dimension != null) {
                boolean bl = true;
                if (component instanceof Scrollable) {
                    boolean bl3 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
                }
                if (bl && dimension2.width > dimension.width) {
                    n2 += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Object object;
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            n += ((Dimension)object).width;
            n2 += ((Dimension)object).height;
        }
        if ((object = ((JScrollPane)container).getViewportBorder()) != null) {
            cloneable = object.getBorderInsets(container);
            n += cloneable.left + cloneable.right;
            n2 += cloneable.top + cloneable.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            cloneable = this.rowHead.getMinimumSize();
            n += ((Dimension)cloneable).width;
            n2 = Math.max(n2, ((Dimension)cloneable).height);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            cloneable = this.colHead.getMinimumSize();
            n = Math.max(n, ((Dimension)cloneable).width);
            n2 += ((Dimension)cloneable).height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            cloneable = this.vsb.getMinimumSize();
            n += ((Dimension)cloneable).width;
            n2 = Math.max(n2, ((Dimension)cloneable).height);
        }
        if (this.hsb != null && this.hsbPolicy != 21) {
            cloneable = this.hsb.getMinimumSize();
            n = Math.max(n, ((Dimension)cloneable).width);
            n2 += ((Dimension)cloneable).height;
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        boolean bl;
        boolean bl2;
        Insets insets;
        Border border;
        Rectangle rectangle = new Rectangle(container.getSize());
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Rectangle rectangle2 = new Rectangle(0, rectangle.y, 0, 0);
        if (this.colHead != null && this.colHead.isVisible()) {
            int n;
            rectangle2.height = n = this.colHead.getPreferredSize().height;
            rectangle.y += n;
            rectangle.height -= n;
        }
        Rectangle rectangle3 = new Rectangle(rectangle.x, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n;
            rectangle3.width = n = this.rowHead.getPreferredSize().width;
            rectangle.x += n;
            rectangle.width -= n;
        }
        if ((border = ((JScrollPane)container).getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        rectangle2.x = rectangle.x;
        rectangle3.y = rectangle.y;
        Component component = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        Rectangle rectangle4 = new Rectangle(0, rectangle.y - insets.top, 0, 0);
        boolean bl3 = bl2 = this.vsbPolicy == 22 || dimension.height > dimension2.height && this.vsbPolicy == 20;
        if (this.vsb != null && bl2) {
            int n = this.vsb.getPreferredSize().width;
            rectangle.width -= n;
            rectangle4.x = rectangle.x + rectangle.width + insets.right;
            rectangle4.width = n;
        }
        Rectangle rectangle5 = new Rectangle(rectangle.x - insets.left, 0, 0, 0);
        boolean bl4 = bl = this.hsbPolicy == 32 || dimension.width > dimension2.width && this.hsbPolicy == 30;
        if (this.hsb != null && bl) {
            int n = this.hsb.getPreferredSize().height;
            rectangle.height -= n;
            rectangle5.y = rectangle.y + rectangle.height + insets.bottom;
            rectangle5.height = n;
            if (this.vsb != null && !bl2 && this.vsbPolicy != 21) {
                dimension2 = this.viewport.toViewCoordinates(rectangle.getSize());
                boolean bl5 = bl2 = dimension.height > dimension2.height;
                if (bl2) {
                    int n2 = this.vsb.getPreferredSize().width;
                    rectangle.width -= n2;
                    rectangle4.x = rectangle.x + rectangle.width + insets.right;
                    rectangle4.width = n2;
                }
            }
        }
        rectangle4.height = rectangle.height + insets.top + insets.bottom;
        rectangle5.width = rectangle.width + insets.left + insets.right;
        rectangle3.height = rectangle.height;
        rectangle2.width = rectangle.width;
        if (this.viewport != null) {
            this.viewport.setBounds(rectangle);
        }
        if (this.rowHead != null) {
            this.rowHead.setBounds(rectangle3);
        }
        if (this.colHead != null) {
            this.colHead.setBounds(rectangle2);
        }
        if (this.vsb != null) {
            if (bl2) {
                this.vsb.setVisible(true);
                this.vsb.setBounds(rectangle4);
            } else {
                this.vsb.setVisible(false);
            }
        }
        if (this.hsb != null) {
            if (bl) {
                this.hsb.setVisible(true);
                this.hsb.setBounds(rectangle5);
            } else {
                this.hsb.setVisible(false);
            }
        }
        if (this.lowerLeft != null) {
            this.lowerLeft.setBounds(rectangle3.x, rectangle5.y, rectangle3.width, rectangle5.height);
        }
        if (this.lowerRight != null) {
            this.lowerRight.setBounds(rectangle4.x, rectangle5.y, rectangle4.width, rectangle5.height);
        }
        if (this.upperLeft != null) {
            this.upperLeft.setBounds(rectangle3.x, rectangle2.y, rectangle3.width, rectangle2.height);
        }
        if (this.upperRight != null) {
            this.upperRight.setBounds(rectangle4.x, rectangle2.y, rectangle4.width, rectangle2.height);
        }
    }

    public Rectangle getViewportBorderBounds(JScrollPane jScrollPane) {
        int n;
        Rectangle rectangle = new Rectangle(jScrollPane.getSize());
        Insets insets = jScrollPane.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this.colHead != null && this.colHead.isVisible()) {
            n = this.colHead.getHeight();
            rectangle.y += n;
            rectangle.height -= n;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n = this.rowHead.getWidth();
            rectangle.x += n;
            rectangle.width -= n;
        }
        if (this.vsb != null && this.vsb.isVisible()) {
            rectangle.width -= this.vsb.getWidth();
        }
        if (this.hsb != null && this.hsb.isVisible()) {
            rectangle.height -= this.hsb.getHeight();
        }
        return rectangle;
    }
}

