/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.DefaultSingleSelectionModel;
import com.sun.java.swing.GrayFilter;
import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.SingleSelectionModel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.TabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    protected int tabPlacement = 1;
    protected SingleSelectionModel model;
    private boolean haveRegistered;
    protected ChangeListener changeListener;
    Vector pages;
    protected transient ChangeEvent changeEvent;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public JTabbedPane() {
        this(1);
    }

    public JTabbedPane(int n) {
        this.setTabPlacement(n);
        this.pages = new Vector(1);
        this.setModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    public void updateUI() {
        int n = this.getTabCount();
        while (n-- > 0) {
            Page page = (Page)this.pages.elementAt(n);
            Component component = page.component;
            page.needsUIUpdate = component.getParent() != this && component instanceof Container;
        }
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TabbedPaneUI";
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : JComponent.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.getModel();
        if (singleSelectionModel2 != null) {
            singleSelectionModel2.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        this.model = singleSelectionModel;
        if (singleSelectionModel != null) {
            this.changeListener = this.createChangeListener();
            singleSelectionModel.addChangeListener(this.changeListener);
        }
        this.firePropertyChange("model", singleSelectionModel2, singleSelectionModel);
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement != n) {
            int n2 = this.tabPlacement;
            this.tabPlacement = n;
            this.firePropertyChange("tabPlacement", n2, n);
            this.invalidate();
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        int n2 = this.model.getSelectedIndex();
        this.model.setSelectedIndex(n);
        if (n2 >= 0 && n2 != n) {
            Page cfr_ignored_0 = (Page)this.pages.elementAt(n2);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (n >= 0 && n2 != n) {
            Page cfr_ignored_1 = (Page)this.pages.elementAt(n);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
        }
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getComponentAt(n);
    }

    public void setSelectedComponent(Component component) {
        int n = this.indexOfComponent(component);
        if (n != -1) {
            this.setSelectedIndex(n);
            return;
        }
        throw new IllegalArgumentException("component not found in tabbed pane");
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        ImageIcon imageIcon = null;
        if (icon != null && icon instanceof ImageIcon) {
            imageIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        this.pages.insertElementAt(new Page(this, string != null ? string : "", icon, imageIcon, component, string2), n);
        this.invalidate();
        if (this.pages.size() == 1) {
            this.setSelectedIndex(0);
        }
        if (!this.haveRegistered && string2 != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.haveRegistered = true;
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", null, component);
        }
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.insertTab(string, icon, component, string2, this.pages.size());
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, null, this.pages.size());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, null, this.pages.size());
    }

    public void removeTabAt(int n) {
        int n2 = this.getTabCount();
        int n3 = this.getSelectedIndex();
        if (n3 >= n2 - 1) {
            this.setSelectedIndex(n3 - 1);
        }
        Component component = this.getComponentAt(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", component, null);
        }
        this.pages.removeElementAt(n);
        this.invalidate();
    }

    public int getTabCount() {
        return this.pages.size();
    }

    public int getTabRunCount() {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabRunCount(this);
        }
        return 0;
    }

    public String getTitleAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).title;
    }

    public Icon getIconAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).icon;
    }

    public Icon getDisabledIconAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).disabledIcon;
    }

    public Color getBackgroundAt(int n) {
        return ((Page)this.pages.elementAt(n)).getBackground();
    }

    public Color getForegroundAt(int n) {
        return ((Page)this.pages.elementAt(n)).getForeground();
    }

    public boolean isEnabledAt(int n) {
        return ((Page)this.pages.elementAt(n)).isEnabled();
    }

    public Component getComponentAt(int n) {
        return ((Page)this.pages.elementAt((int)n)).component;
    }

    public Rectangle getBoundsAt(int n) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabBounds(this, n);
        }
        return null;
    }

    public void setTitleAt(int n, String string) {
        String string2 = ((Page)this.pages.elementAt((int)n)).title;
        ((Page)this.pages.elementAt((int)n)).title = string;
        this.invalidate();
        if (string2 != string && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
    }

    public void setIconAt(int n, Icon icon) {
        Icon icon2 = ((Page)this.pages.elementAt((int)n)).icon;
        ((Page)this.pages.elementAt((int)n)).icon = icon;
        this.invalidate();
        this.getAccessibleContext();
        if (icon2 != icon && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
    }

    public void setDisabledIconAt(int n, Icon icon) {
        ((Page)this.pages.elementAt((int)n)).disabledIcon = icon;
        if (!this.isEnabledAt(n)) {
            this.invalidate();
        }
    }

    public void setBackgroundAt(int n, Color color) {
        ((Page)this.pages.elementAt(n)).setBackground(color);
        this.repaint();
    }

    public void setForegroundAt(int n, Color color) {
        ((Page)this.pages.elementAt(n)).setForeground(color);
        this.repaint();
    }

    public void setEnabledAt(int n, boolean bl) {
        ((Page)this.pages.elementAt(n)).setEnabled(bl);
        this.repaint();
    }

    public void setComponentAt(int n, Component component) {
        ((Page)this.pages.elementAt((int)n)).component = component;
        this.invalidate();
    }

    public int indexOfTab(String string) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (this.getTitleAt(n).equals(string == null ? "" : string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfTab(Icon icon) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (this.getIconAt(n).equals(icon)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfComponent(Component component) {
        int n = 0;
        while (n < this.getTabCount()) {
            if (this.getComponentAt(n).equals(component)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        if (this.ui != null && (n = ((TabbedPaneUI)this.ui).tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY())) != -1) {
            return ((Page)this.pages.elementAt((int)n)).tip;
        }
        return super.getToolTipText(mouseEvent);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane.this.fireStateChanged();
            int n = JTabbedPane.this.getTabCount();
            while (n-- > 0) {
                Page page = (Page)JTabbedPane.this.pages.elementAt(n);
                Component component = page.component;
                if (!page.needsUIUpdate || component.getParent() != JTabbedPane.this || !(component instanceof Container)) continue;
                SwingUtilities.updateComponentTreeUI(component);
                page.needsUIUpdate = false;
                component.validate();
            }
        }

        ModelListener() {
            JTabbedPane.this = JTabbedPane.this;
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public AccessibleJTabbedPane() {
            JTabbedPane.this = JTabbedPane.this;
            JTabbedPane.this.model.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return JTabbedPane.this.getTabCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= JTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.elementAt(n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = ((TabbedPaneUI)JTabbedPane.this.ui).tabForCoordinate(JTabbedPane.this, point.x, point.y);
            if (n == -1) {
                n = JTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = JTabbedPane.this.getSelectedIndex();
            if (n2 == -1) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.elementAt(n2);
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JTabbedPane.this.getSelectedIndex();
        }

        public void addAccessibleSelection(int n) {
            JTabbedPane.this.setSelectedIndex(n);
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    private class Page
    extends AccessibleContext
    implements Serializable,
    Accessible,
    AccessibleComponent {
        String title;
        Color background;
        Color foreground;
        Icon icon;
        Icon disabledIcon;
        JTabbedPane parent;
        Component component;
        String tip;
        boolean enabled = true;
        boolean needsUIUpdate;

        Page(JTabbedPane jTabbedPane2, String string, Icon icon, Icon icon2, Component component, String string2) {
            AccessibleContext accessibleContext;
            JTabbedPane.this = JTabbedPane.this;
            this.title = string;
            this.icon = icon;
            this.disabledIcon = icon2;
            this.parent = jTabbedPane2;
            this.setAccessibleParent(jTabbedPane2);
            this.component = component;
            this.tip = string2;
            if (component instanceof Accessible && (accessibleContext = ((Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(this);
            }
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.title != null) {
                return this.title;
            }
            return null;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (this.tip != null) {
                return this.tip;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.parent.getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            int n = this.parent.indexOfTab(this.title);
            if (n == this.parent.getSelectedIndex()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return this.parent.indexOfTab(this.title);
        }

        public int getAccessibleChildrenCount() {
            if (this.component instanceof Accessible) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public Locale getLocale() {
            return this.parent.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            if (this.background != null) {
                return this.background;
            }
            return this.parent.getBackground();
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public Color getForeground() {
            if (this.foreground != null) {
                return this.foreground;
            }
            return this.parent.getForeground();
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public Cursor getCursor() {
            return this.parent.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.parent.setCursor(cursor);
        }

        public Font getFont() {
            return this.parent.getFont();
        }

        public void setFont(Font font) {
            ((Component)this.parent).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.parent.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isVisible() {
            return this.parent.isVisible();
        }

        public void setVisible(boolean bl) {
            this.parent.setVisible(bl);
        }

        public boolean isShowing() {
            return this.parent.isShowing();
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            return rectangle.contains(point);
        }

        public Point getLocationOnScreen() {
            Point point = this.parent.getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            return point2;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            return new Point(rectangle.x, rectangle.y);
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            return this.parent.getUI().getTabBounds(this.parent, this.parent.indexOfTab(this.title));
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            return new Dimension(rectangle.width, rectangle.height);
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

