/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.SwingUtilities;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Locale;

public class Box
extends Container
implements Accessible {
    private static final String base = "box";
    private static int nameCounter;
    protected AccessibleContext accessibleContext;

    public Box(int n) {
        this.setName(base + nameCounter++);
        super.setLayout(new BoxLayout(this, n));
    }

    public static Box createHorizontalBox() {
        return new Box(0);
    }

    public static Box createVerticalBox() {
        return new Box(1);
    }

    public static Component createRigidArea(Dimension dimension) {
        return new Filler(dimension, dimension, dimension);
    }

    public static Component createHorizontalStrut(int n) {
        return new Filler(new Dimension(n, 0), new Dimension(n, 0), new Dimension(n, Short.MAX_VALUE));
    }

    public static Component createVerticalStrut(int n) {
        return new Filler(new Dimension(0, n), new Dimension(0, n), new Dimension(Short.MAX_VALUE, n));
    }

    public static Component createGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public static Component createHorizontalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
    }

    public static Component createVerticalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
    }

    public void setLayout(LayoutManager layoutManager) {
        throw new AWTError("Illegal request");
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBox();
        }
        return this.accessibleContext;
    }

    public static class Filler
    extends Component {
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;
        protected AccessibleContext accessibleContext;

        public Filler(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.reqMin = dimension;
            this.reqPref = dimension2;
            this.reqMax = dimension3;
        }

        public void changeShape(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.reqMin = dimension;
            this.reqPref = dimension2;
            this.reqMax = dimension3;
            this.invalidate();
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleBoxFiller();
            }
            return this.accessibleContext;
        }

        protected class AccessibleBoxFiller
        extends AccessibleContext
        implements Serializable,
        AccessibleComponent {
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.FILLER;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return SwingUtilities.getAccessibleStateSet(Filler.this);
            }

            public Accessible getAccessibleParent() {
                Container container = Filler.this.getParent();
                if (container instanceof Accessible) {
                    return (Accessible)((Object)container);
                }
                return null;
            }

            public int getAccessibleIndexInParent() {
                return SwingUtilities.getAccessibleIndexInParent(Filler.this);
            }

            public int getAccessibleChildrenCount() {
                return SwingUtilities.getAccessibleChildrenCount(Filler.this);
            }

            public Accessible getAccessibleChild(int n) {
                return SwingUtilities.getAccessibleChild(Filler.this, n);
            }

            public Locale getLocale() {
                return Filler.this.getLocale();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public Color getBackground() {
                return Filler.this.getBackground();
            }

            public void setBackground(Color color) {
                Filler.this.setBackground(color);
            }

            public Color getForeground() {
                return Filler.this.getForeground();
            }

            public void setForeground(Color color) {
                Filler.this.setForeground(color);
            }

            public Cursor getCursor() {
                return Filler.this.getCursor();
            }

            public void setCursor(Cursor cursor) {
                Filler.this.setCursor(cursor);
            }

            public Font getFont() {
                return Filler.this.getFont();
            }

            public void setFont(Font font) {
                Filler.this.setFont(font);
            }

            public FontMetrics getFontMetrics(Font font) {
                return Filler.this.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return Filler.this.isEnabled();
            }

            public void setEnabled(boolean bl) {
                Filler.this.setEnabled(bl);
            }

            public boolean isVisible() {
                return Filler.this.isVisible();
            }

            public void setVisible(boolean bl) {
                Filler.this.setVisible(bl);
            }

            public boolean isShowing() {
                return Filler.this.isShowing();
            }

            public boolean contains(Point point) {
                return Filler.this.contains(point);
            }

            public Point getLocationOnScreen() {
                return Filler.this.getLocationOnScreen();
            }

            public Point getLocation() {
                return Filler.this.getLocation();
            }

            public void setLocation(Point point) {
                Filler.this.setLocation(point);
            }

            public Rectangle getBounds() {
                return Filler.this.getBounds();
            }

            public void setBounds(Rectangle rectangle) {
                Filler.this.setBounds(rectangle);
            }

            public Dimension getSize() {
                return Filler.this.getSize();
            }

            public void setSize(Dimension dimension) {
                Filler.this.setSize(dimension);
            }

            public Accessible getAccessibleAt(Point point) {
                return SwingUtilities.getAccessibleAt(Filler.this, point);
            }

            public boolean isFocusTraversable() {
                return Filler.this.isFocusTraversable();
            }

            public void requestFocus() {
                Filler.this.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                Filler.this.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                Filler.this.removeFocusListener(focusListener);
            }

            AccessibleBoxFiller() {
                Filler.this = Filler.this;
            }
        }
    }

    protected class AccessibleBox
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILLER;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return SwingUtilities.getAccessibleStateSet(Box.this);
        }

        public Accessible getAccessibleParent() {
            Container container = Box.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(Box.this);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(Box.this);
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(Box.this, n);
        }

        public Locale getLocale() {
            return Box.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Box.this.getBackground();
        }

        public void setBackground(Color color) {
            Box.this.setBackground(color);
        }

        public Color getForeground() {
            return Box.this.getForeground();
        }

        public void setForeground(Color color) {
            Box.this.setForeground(color);
        }

        public Cursor getCursor() {
            return Box.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Box.this.setCursor(cursor);
        }

        public Font getFont() {
            return Box.this.getFont();
        }

        public void setFont(Font font) {
            ((Component)Box.this).setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return Box.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return Box.this.isEnabled();
        }

        public void setEnabled(boolean bl) {
            Box.this.setEnabled(bl);
        }

        public boolean isVisible() {
            return Box.this.isVisible();
        }

        public void setVisible(boolean bl) {
            Box.this.setVisible(bl);
        }

        public boolean isShowing() {
            return Box.this.isShowing();
        }

        public boolean contains(Point point) {
            return Box.this.contains(point);
        }

        public Point getLocationOnScreen() {
            return Box.this.getLocationOnScreen();
        }

        public Point getLocation() {
            return Box.this.getLocation();
        }

        public void setLocation(Point point) {
            Box.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return Box.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            Box.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return Box.this.getSize();
        }

        public void setSize(Dimension dimension) {
            Box.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return SwingUtilities.getAccessibleAt(Box.this, point);
        }

        public boolean isFocusTraversable() {
            return Box.this.isFocusTraversable();
        }

        public void requestFocus() {
            Box.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            Box.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            Box.this.removeFocusListener(focusListener);
        }

        AccessibleBox() {
            Box.this = Box.this;
        }
    }
}

