// SettingsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "MyProxy.h"
#include "SettingsDialog.h"
#include "AddHostDialog.h"
#include "AddRefDialog.h"
#include "MyProxyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg dialog


CSettingsDlg::CSettingsDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSettingsDlg::IDD, pParent)
{
	m_parent = (CMyProxyDlg *) pParent;
//	m_TextOnly = m_parent->m_textOnly;

	//{{AFX_DATA_INIT(CSettingsDlg)
	//}}AFX_DATA_INIT
}


void CSettingsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettingsDlg)
	DDX_Control(pDX, IDC_LIST_2, m_BanRef);
	DDX_Control(pDX, IDC_EDIT1_FILE, m_ConfigFileCtrl);
	DDX_Control(pDX, IDC_TAB_SETTINGS, m_TabSettings);
	DDX_Control(pDX, IDC_LIST_3, m_HostList);
	DDX_Check(pDX, IDC_CHECK_TEXTONLY, m_TextOnly);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSettingsDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingsDlg)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_SETTINGS, OnSelchangeTabSettings)
	ON_BN_CLICKED(IDC_BUTTON_APPLY, OnButtonApply)
	ON_BN_CLICKED(IDC_BUTTON3_ADD, OnButton3Add)
	ON_BN_CLICKED(IDC_BUTTON3_CLEAR, OnButton3Clear)
	ON_BN_CLICKED(IDC_BUTTON3_REM, OnButton3Rem)
	ON_BN_CLICKED(IDC_BUTTON_1_LOAD, OnButton1Load)
	ON_BN_CLICKED(IDC_BUTTON_1_SAVE, OnButton1Save)
	ON_BN_CLICKED(IDOK, OnSettingsOK)
	ON_BN_CLICKED(IDC_CHECK_TEXTONLY, OnCheckTextonly)
	ON_BN_CLICKED(IDC_BUTTON2_ADD, OnButton2Add)
	ON_BN_CLICKED(IDC_BUTTON2_CLEAR, OnButton2Clear)
	ON_BN_CLICKED(IDC_BUTTON2_REM, OnButton2Rem)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg message handlers

BOOL CSettingsDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	TC_ITEM TabCtrlItem;
	TabCtrlItem.mask = TCIF_TEXT;
    TabCtrlItem.pszText = "Configuration";
	m_TabSettings.InsertItem( 0, &TabCtrlItem );
    TabCtrlItem.pszText = "HTML Tags";
	m_TabSettings.InsertItem( 1, &TabCtrlItem );
    TabCtrlItem.pszText = "Banished Hosts";
	m_TabSettings.InsertItem( 2, &TabCtrlItem );


	LRESULT a=0;
	OnSelchangeTabSettings(0, &a);

	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(FALSE);

    POSITION pos;   

	//Update Config File Name
	m_ConfigFileCtrl.SetWindowText(m_parent->m_ConfFile.GetBuffer(m_parent->m_ConfFile.GetLength()));

	//Update Text Only Mode
	m_TextOnly = m_parent->m_textOnly;

	//Update HTML Tags Reference List
	for( pos = m_parent->m_banRef.GetHeadPosition(); pos != NULL; )
		m_BanRef.AddString(m_parent->m_banRef.GetNext( pos ));

	//Update Bannished Hosts List
	for( pos = m_parent->m_banHost.GetHeadPosition(); pos != NULL; )
		m_HostList.AddString(m_parent->m_banHost.GetNext( pos ));
	
	UpdateData(FALSE);
	AdjustExtent(false);
	AdjustExtent(true);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSettingsDlg::OnSelchangeTabSettings(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	switch(m_TabSettings.GetCurSel())
	{
	case -1:break;
	case 0:
		(GetDlgItem(IDC_STATIC_1))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON_1_LOAD))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON_1_SAVE))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_EDIT1_FILE))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_STATIC11))->ShowWindow(SW_SHOW);

		(GetDlgItem(IDC_CHECK_TEXTONLY))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC_2))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_LIST_2))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_ADD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_REM))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_CLEAR))->ShowWindow(SW_HIDE);
		
		(GetDlgItem(IDC_LIST_3))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC_3))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_ADD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_REM))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_CLEAR))->ShowWindow(SW_HIDE);
		break;
	case 1:
		(GetDlgItem(IDC_STATIC_1))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON_1_LOAD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON_1_SAVE))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_EDIT1_FILE))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC11))->ShowWindow(SW_HIDE);

		(GetDlgItem(IDC_CHECK_TEXTONLY))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_STATIC_2))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_LIST_2))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON2_ADD))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON2_REM))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON2_CLEAR))->ShowWindow(SW_SHOW);

		(GetDlgItem(IDC_LIST_3))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC_3))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_ADD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_REM))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_CLEAR))->ShowWindow(SW_HIDE);
		break;
	case 2:
		(GetDlgItem(IDC_STATIC_1))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON_1_LOAD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON_1_SAVE))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_EDIT1_FILE))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC11))->ShowWindow(SW_HIDE);

		(GetDlgItem(IDC_CHECK_TEXTONLY))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC_2))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_LIST_2))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_ADD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_REM))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_CLEAR))->ShowWindow(SW_HIDE);

		(GetDlgItem(IDC_LIST_3))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_STATIC_3))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON3_ADD))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON3_REM))->ShowWindow(SW_SHOW);
		(GetDlgItem(IDC_BUTTON3_CLEAR))->ShowWindow(SW_SHOW);
		break;
	default:
		(GetDlgItem(IDC_STATIC_1))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON_1_LOAD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON_1_SAVE))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_EDIT1_FILE))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC11))->ShowWindow(SW_HIDE);

		(GetDlgItem(IDC_CHECK_TEXTONLY))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC_2))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_LIST_2))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_ADD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_REM))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON2_CLEAR))->ShowWindow(SW_HIDE);

		(GetDlgItem(IDC_LIST_3))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_STATIC_3))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_ADD))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_REM))->ShowWindow(SW_HIDE);
		(GetDlgItem(IDC_BUTTON3_CLEAR))->ShowWindow(SW_HIDE);
		break;
	}
	
	*pResult = 0;
}

void CSettingsDlg::OnButtonApply() 
{
	UpdateData(TRUE);
	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(FALSE);

	CString str;

	//Update ConfigFile Name
	 m_ConfigFileCtrl.GetWindowText(m_parent->m_ConfFile);

	 //Update Text Only Mode
	 m_parent->m_textOnly = m_TextOnly;

	//Update HTML Tags reference List
	m_parent->m_banRef.RemoveAll();
	for(int i = 0; i < m_BanRef.GetCount(); i++)
	{
		m_BanRef.GetText(i,str);
		m_parent->m_banRef.AddTail(str);
	}

	//Update Bannished Host List
	m_parent->m_banHost.RemoveAll();
	for(i = 0; i < m_HostList.GetCount(); i++)
	{
		m_HostList.GetText(i,str);
		m_parent->m_banHost.AddTail(str);
	}
}

void CSettingsDlg::OnButton3Add() 
{
	CAddHostDlg dlg;

	if(dlg.DoModal() == IDOK)
	{
		if(strcmp(dlg.m_hostAddress,""))
		{
			m_HostList.AddString(dlg.m_hostAddress);
			AdjustExtent(true);
			(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
		}
	}
}

void CSettingsDlg::OnButton3Clear() 
{
	m_HostList.ResetContent();
	AdjustExtent(true);
	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
}

void CSettingsDlg::OnButton3Rem() 
{
	int tab[100];

	m_HostList.GetSelItems(100, tab);

	for(int i=m_HostList.GetSelCount(); i>0; i--)
		m_HostList.DeleteString(tab[i-1]);

	AdjustExtent(true);
	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
}

//LOAD PROXY SETTINGS
void CSettingsDlg::OnButton1Load() 
{
	CFileDialog dlg(TRUE, ".pfg", 
		m_parent->m_ConfFile.IsEmpty() ? "config.pfg" : m_parent->m_ConfFile, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
		"Proxy Filter Files (*.pfg)|*.pfg|", 
		NULL);

	if(dlg.DoModal() == IDOK)
	{
		CString str = dlg.GetPathName();
		
		TRY
		{   
			CFile mf(str.GetBuffer(str.GetLength()),CFile::modeRead);
			char buf[512];
			CArchive arch( &mf, CArchive::load, 512, buf );

			if(MySerialize(arch))
			{
				m_ConfigFileCtrl.SetWindowText(str.GetBuffer(str.GetLength()));

				UpdateData(FALSE);
				OnButtonApply();
				AdjustExtent(false);
				AdjustExtent(true);
			}
			else
				AfxMessageBox("Invalid Configuration File");
		}
		CATCH( CFileException, e )
		{
			AfxMessageBox("File could not be opened!");
		}
		END_CATCH
	}
}

//SAVE PROXY SETTINGS
void CSettingsDlg::OnButton1Save() 
{
	CFileDialog dlg(FALSE, 
		".pfg", m_parent->m_ConfFile.IsEmpty() ? "config.pfg" : m_parent->m_ConfFile, 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		"Proxy Filter Files (*.pfg)|*.pfg|", 
		NULL);

	if(dlg.DoModal() == IDOK)
	{
		CString str = dlg.GetPathName();

		TRY
		{   
			CFile mf(str.GetBuffer(str.GetLength()),CFile::modeWrite | CFile::modeCreate);
			
			char buf[512];
			CArchive arch( &mf, CArchive::store, 512, buf );

			m_ConfigFileCtrl.SetWindowText(str.GetBuffer(str.GetLength()));
			OnButtonApply();

			MySerialize(arch);

		}
		CATCH( CFileException, e )
		{
			AfxMessageBox("File could not be opened!");
		}
		END_CATCH
	}
}

///////////////////////////////////////////////

int CSettingsDlg::MySerialize(CArchive &ar)
{
	int countHost = m_HostList.GetCount();
	int countBan = m_BanRef.GetCount();
	CString str;
	int i;

	if(ar.IsStoring())
	{
		str = "Proxy Filter 1.0\n";
		ar.WriteString(str.GetBuffer(str.GetLength()));

		//saving Text Only mode
		ar.Write(&m_TextOnly,   sizeof(BOOL)); 

		//saving HTML Tags List
		ar.Write(&countBan, sizeof(int));

		for(i = 0; i < countBan; i++)
		{
			m_BanRef.GetText(i, str);
			ar.WriteString(str.GetBuffer(str.GetLength()));
			ar.Write("\n", 1);
		}

		//saving Bannished Hosts List
		ar.Write(&countHost, sizeof(int));

		for(i = 0; i < countHost; i++)
		{
			m_HostList.GetText(i, str);
			ar.WriteString(str.GetBuffer(str.GetLength()));
			ar.Write("\n", 1);
		}
	}
	else
	{
		ar.ReadString(str);

		if(strcmp(str, "Proxy Filter 1.0"))
			return 0;

		
		m_HostList.ResetContent();
		m_BanRef.ResetContent();

		//retrieving Text Only mode
		ar.Read(&m_TextOnly,   sizeof(BOOL)); 

		//retrieving HTML Tags List
		ar.Read(&countBan, sizeof(int));

		for(i = 0; i < countBan; i++)
		{
			ar.ReadString(str);
			m_BanRef.AddString(str.GetBuffer(str.GetLength()));
		}

		//retrieving Banished Host list
		ar.Read(&countHost, sizeof(int));

		for(i = 0; i < countHost; i++)
		{
			ar.ReadString(str);
			m_HostList.AddString(str.GetBuffer(str.GetLength()));
		}
	}
	return 1;
}



void CSettingsDlg::OnSettingsOK() 
{
	// TODO: Add your control notification handler code here
	OnButtonApply();
	OnOK();
}

void CSettingsDlg::OnCheckTextonly() 
{
	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
}

void CSettingsDlg::OnButton2Add() 
{
	CAddRefDlg dlg;

	if(dlg.DoModal() == IDOK)
	{
		if(!dlg.m_Tag.IsEmpty())
		{
			CString str=dlg.m_Tag;
			
			if(!dlg.m_Param.IsEmpty())
			{
				str+= " " + dlg.m_Param;
				
				if(!dlg.m_Host.IsEmpty())
				{
					str+= " " + dlg.m_Host;

					m_BanRef.AddString(str.GetBuffer(str.GetLength()));
					AdjustExtent(false);					
					(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
				}
				else
				{
					m_BanRef.AddString(str.GetBuffer(str.GetLength()));
					AdjustExtent(false);					
					(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
				}
			}
			else
			{
				m_BanRef.AddString(str.GetBuffer(str.GetLength()));
				AdjustExtent(false);					
				(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
			}
		}
		else
		{
			MessageBox("You Must Enter an HTML Tag","Proxy Filter", MB_ICONEXCLAMATION | MB_OK);

		}
	}
}
void CSettingsDlg::OnButton2Clear() 
{
	m_BanRef.ResetContent();
	AdjustExtent(false);
	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
}

void CSettingsDlg::OnButton2Rem() 
{
	int tab[100];

	m_BanRef.GetSelItems(100, tab);

	for(int i=m_BanRef.GetSelCount(); i>0; i--)
		m_BanRef.DeleteString(tab[i-1]);

	AdjustExtent(false);
	(GetDlgItem(IDC_BUTTON_APPLY))->EnableWindow(TRUE);
}


void CSettingsDlg::AdjustExtent(bool which)
{
	CListBox *pLB = (which == false) ? &m_BanRef : &m_HostList;
	CDC   *pDC    = pLB->GetDC();
	int   ex	  = 0;
	int count     = pLB->GetCount();
	CSize sz;
	CString str;
	
	for(int i=0; i< count; i++)
	{
		pLB->GetText(i, str);
        sz = pDC->GetTextExtent(str, str.GetLength());
		
		if (sz.cx > ex)
			ex = sz.cx;
	}
	
	pLB->ReleaseDC(pDC);

	if(ex != pLB->GetHorizontalExtent())
		pLB->SetHorizontalExtent(ex);
}
