// SelectPortDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MyProxy.h"
#include "SelectPortDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectPortDlg dialog


CSelectPortDlg::CSelectPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSelectPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectPortDlg)
	m_Port = 8080;
	m_ProxyPort = 0;
	m_HasProxy = FALSE;
	m_LocalHost = FALSE;
	m_IP0 = 0;
	m_IP1 = 0;
	m_IP2 = 0;
	m_IP3 = 0;
	//}}AFX_DATA_INIT
}


void CSelectPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectPortDlg)
	DDX_Text(pDX, IDC_EDIT_PORT, m_Port);
	DDV_MinMaxUInt(pDX, m_Port, 0, 65535);
	DDX_Text(pDX, IDC_EDIT_PROXY_PORT, m_ProxyPort);
	DDV_MinMaxUInt(pDX, m_ProxyPort, 0, 65535);
	DDX_Check(pDX, IDC_CHECK_PROXY, m_HasProxy);
	DDX_Check(pDX, IDC_CHECK_LOCALHOST, m_LocalHost);
	DDX_Text(pDX, IDC_EDIT_IP0, m_IP0);
	DDV_MinMaxUInt(pDX, m_IP0, 0, 255);
	DDX_Text(pDX, IDC_EDIT_IP1, m_IP1);
	DDV_MinMaxUInt(pDX, m_IP1, 0, 255);
	DDX_Text(pDX, IDC_EDIT_IP2, m_IP2);
	DDV_MinMaxUInt(pDX, m_IP2, 0, 255);
	DDX_Text(pDX, IDC_EDIT_IP3, m_IP3);
	DDV_MinMaxUInt(pDX, m_IP3, 0, 255);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectPortDlg, CDialog)
	//{{AFX_MSG_MAP(CSelectPortDlg)
	ON_BN_CLICKED(IDC_CHECK_PROXY, OnCheckProxy)
	ON_BN_CLICKED(IDC_CHECK_LOCALHOST, OnCheckLocalHost)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CSelectPortDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
/////////////////////////////////////////////////////////////////////////////
// CSelectPortDlg message handlers

void CSelectPortDlg::OnCheckProxy() 
{
	UpdateData(TRUE);
	if(m_HasProxy)
	{
		GetDlgItem(IDC_EDIT_IP0)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP1)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP2)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP3)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_PROXY_PORT)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_LOCALHOST)->EnableWindow(TRUE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_IP0)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_IP1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_IP2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_IP3)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_PROXY_PORT)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_LOCALHOST)->EnableWindow(FALSE);
	}
}

void CSelectPortDlg::OnCheckLocalHost()
{
	UpdateData(TRUE);
	if(m_LocalHost)
	{
		GetDlgItem(IDC_EDIT_IP0)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_IP1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_IP2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_IP3)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_IP0)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP1)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP2)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_IP3)->EnableWindow(TRUE);
	}
}

void CSelectPortDlg::GetProxyIP(DWORD &dwip)
{
	dwip = 0;
	dwip  = m_IP3 <<24;
	dwip += m_IP2 <<16;
	dwip += m_IP1 <<8;
	dwip += m_IP0;
}
