// ProxyThread.cpp : implementation file
//

#include "stdafx.h"
#include "MyProxy.h"
#include "ProxyThread.h"

#include <winsock2.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProxyThread

IMPLEMENT_DYNCREATE(CProxyThread, CWinThread)

CProxyThread::	CProxyThread(HWND mother, UINT port)
{
	m_Mother    = mother;
	m_Port	    = port;
}

CProxyThread::~CProxyThread()
{
}

BOOL CProxyThread::InitInstance()
{
	// TODO:  perform and per-thread initialization here
	return TRUE;
}

int CProxyThread::ExitInstance()
{
	// TODO:  perform any per-thread cleanup here
	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CProxyThread, CWinThread)
	//{{AFX_MSG_MAP(CProxyThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProxyThread message handlers

int CProxyThread::Run() 
{
 SOCKET mysock = 0;					//Listening Socket
 struct sockaddr_in mysockaddr;		//Listening Socket structure
 SOCKET *pSock = 0;					//Client Connect Socket

//creating the socket
 if( (mysock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET)
 {
	 PostMessage(m_Mother, WM_SOCKET_ERROR, 0, 0);
	 return -1;
 }

 //retrieving HostName
 mysockaddr.sin_family = AF_INET;
 mysockaddr.sin_port = htons(m_Port);
 if(GetHostAddress(mysockaddr) == SOCKET_ERROR)
 {
	 PostMessage(m_Mother, WM_SOCKET_ERROR, 0, 0);
	 return -1;
 }

//Binding Socket on Localhost
 if(bind(mysock, (struct sockaddr *) &mysockaddr, sizeof(mysockaddr)) == SOCKET_ERROR)
 {
	 PostMessage(m_Mother, WM_SOCKET_ERROR, 0, 0);
	 return -1;
 }

 //Listening Socket
 if(listen(mysock, SOMAXCONN) == SOCKET_ERROR)
 {
	 PostMessage(m_Mother, WM_SOCKET_ERROR, 0, 0);
	 return -1;
 }

 //infinite loop
 for(;;)
 {
	 pSock = new SOCKET;

	 if(( *pSock = accept(mysock, NULL, NULL)) == SOCKET_ERROR)
		 PostMessage(m_Mother, WM_SOCKET_ERROR, 0, 0);

	 PostMessage(m_Mother, WM_CLIENT_CONNECT, 0, LPARAM (pSock));
 }
 
 closesocket(mysock);
 return 0;
}

//Retrieve The host address of addr (or localhost if addr = null)
UINT CProxyThread::GetHostAddress(struct sockaddr_in &sad, char *addr)
{
	char in_host[100];
	struct hostent* myhostent=0;

	if(!addr)
	{
		if(gethostname(in_host, 100) == SOCKET_ERROR)
			return SOCKET_ERROR;
		
		if((myhostent=gethostbyname(in_host)) == 0)
			return SOCKET_ERROR;
	}
	else
	{
		if (isalpha(addr[0])) /* server address is a name */ 
			myhostent = gethostbyname(addr); 
		else  /* Convert nnn.nnn address to a usable one */ 
		{ 
			unsigned int iad = 0;

			iad = inet_addr(addr); 
			myhostent = gethostbyaddr((char *)&iad,4,AF_INET); 
		}
		
		if (myhostent == NULL )
			return SOCKET_ERROR;
	}

	memcpy(&(sad.sin_addr), myhostent->h_addr, myhostent->h_length);
	return SOCKET_ERROR+1;
}
