// MyProxyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MyProxy.h"
#include "MyProxyDlg.h"

#include <winsock2.h>
#include "SelectPortDialog.h"
#include "SettingsDialog.h"
#include "ProxyThread.h"
#include "ClientThread.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyProxyDlg dialog

CMyProxyDlg::CMyProxyDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMyProxyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMyProxyDlg)
	m_NbConn = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMyProxyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyProxyDlg)
	DDX_Control(pDX, IDC_LIST_REQUETE, m_ListRequete);
	DDX_Text(pDX, IDC_EDIT_NBCONN, m_NbConn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyProxyDlg, CDialog)
	//{{AFX_MSG_MAP(CMyProxyDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_MESSAGE(WM_CLIENT_CONNECT, OnClientConnect)
	ON_MESSAGE(WM_SOCKET_ERROR, OnSockError)
	ON_MESSAGE(WM_REF, OnRefData)
	ON_MESSAGE(WM_REQ, OnHTTPRequest)
	ON_BN_CLICKED(IDC_BUTTON_SETTINGS, OnButtonSettings)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyProxyDlg message handlers

BOOL CMyProxyDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		//////////////!!!!!!!!!!!!!!!//////////////
		pSysMenu->RemoveMenu(SC_SIZE,MF_BYCOMMAND);
		pSysMenu->RemoveMenu(SC_MAXIMIZE,MF_BYCOMMAND);
		pSysMenu->EnableMenuItem(SC_CLOSE,MF_BYCOMMAND | MF_GRAYED);

		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	WSADATA wsaData;				//WSAStartup parameter
	
	//Loading WSA Libraries
	if( WSAStartup( MAKEWORD(2, 0), &wsaData) != 0)
		return -1;

	m_banHost.RemoveAll();
	m_banRef.RemoveAll();
	m_ConfFile.Empty();
	m_HasProxy = FALSE;
	m_ListRequete.ResetContent();
	m_Port = 0;
	m_ProxyIp = 0;
	m_ProxyPort = 0;
	m_ProxyTask = 0;
	m_textOnly = FALSE;

	//Display Select Port Window	
	CSelectPortDlg dlg;

	if(dlg.DoModal() == IDOK)
	{
		m_Port = dlg.m_Port;
		m_HasProxy = dlg.m_HasProxy;
		if(m_HasProxy)
		{
			m_ProxyPort = dlg.m_ProxyPort;
			
			if(dlg.m_LocalHost)
				m_ProxyIp = 0;
			else
				dlg.GetProxyIP(m_ProxyIp);
		}
	}
	else
		PostQuitMessage(-1);

	m_ProxyTask = new CProxyThread(m_hWnd, m_Port);
	m_ProxyTask->CreateThread();
		
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMyProxyDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyProxyDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyProxyDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
//Button Handlers

void CMyProxyDlg::OnButtonClear() 
{
	m_ListRequete.ResetContent();
	m_ListRequete.SetHorizontalExtent(0);
}

void CMyProxyDlg::OnClose() 
{
	WSACleanup();

	CDialog::OnClose();
}

void CMyProxyDlg::OnButtonSettings() 
{
	CSettingsDlg dlg(this);
	dlg.DoModal();
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
//User Defined Message Handlers

LRESULT CMyProxyDlg::OnRefData(WPARAM todo, LPARAM pad)
{
	if(todo)
		m_NbConn++;
	else
	{
		if(m_NbConn)
			m_NbConn--;
	}
	UpdateData(FALSE);
	return 0;
}


LRESULT CMyProxyDlg::OnHTTPRequest(WPARAM pad, LPARAM stradr)
{
	if(stradr)
	{
//		CString *s = (CString *) stradr;
//		m_ListRequete.InsertString(0, s->GetBuffer(s->GetLength()));
//		AdjustExtent(*s);
		CString s;
		s = (char *) stradr;
		m_ListRequete.InsertString(0, s.GetBuffer(s.GetLength()));
		AdjustExtent(s);
		delete[] ((char *)stradr);
	}
	return 0;
}

LRESULT CMyProxyDlg::OnSockError(WPARAM pad1, LPARAM pad2)
{
	AfxMessageBox("CONNECTION ERROR\nTry Another port and check your connections!");
	PostQuitMessage(-1);
	return 0;
}

LRESULT CMyProxyDlg::OnClientConnect(WPARAM pad, LPARAM adsock)
{
	CClientThread *cli = new CClientThread(this, (SOCKET*) adsock);
	
	if(cli != NULL)
		cli->CreateThread();
	return 0;
}


void CMyProxyDlg::AdjustExtent(CString str)
{
     CDC   *pDC = m_ListRequete.GetDC();
	 int   ex	= m_ListRequete.GetHorizontalExtent();
     CSize sz   = pDC->GetTextExtent(str);
	 
	 if (sz.cx > ex)
	 {
		 ex = sz.cx;
		 m_ListRequete.ReleaseDC(pDC);
		 m_ListRequete.SetHorizontalExtent(ex);
	 }
	 else		 		 
		 m_ListRequete.ReleaseDC(pDC);
}
